package cn.com.poc.appbuilder.rest;

import cn.com.poc.appbuilder.api.entity.BaiduAppBuilderDescribeAppListResult;
import cn.com.poc.appbuilder.api.entity.BaiduAppBuilderDescribeAppResult;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestParam;

@Permission(Access.Anonymous)
public interface AppBuilderDescribeAppRest extends BaseRest {
    /**
     * 查询用户应用详情
     *
     * @param appId 应用的ID - app_id
     * @return 返回用户应用详情
     */
    BaiduAppBuilderDescribeAppResult getDescribeApp(@RequestParam String appId) throws Exception;

    /**
     * 查询用户应用详情
     *
     * @param marker 起始位置
     * @param maxKeys 数据大小，默认10，最大值100
     * @return 返回用户应用列表
     */
    BaiduAppBuilderDescribeAppListResult getDescribeAppList(@RequestParam String marker, @RequestParam Integer maxKeys) throws Exception;

}
