package cn.com.poc.appbuilder.rest;

import cn.com.poc.appbuilder.dto.AppBuilderCommunicationDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;


@Permission(Access.Safety)
public interface AppBuilderRest extends BaseRest {


    /**
     * 新建对话-【有效期7天】
     *
     * @param appId 应用的ID - app_id
     * @return 返回新建对话的ID - conversation_id
     */
    String conversation(@RequestParam String appId) throws Exception;

    /**
     * 文件上传
     *
     * @param appId          应用的ID - app_id
     * @param conversationId 对话的ID - conversation_id
     * @param file           文件
     * @return 返回文件ID - file_id
     */
    String upload(@RequestParam String appId, @RequestParam String conversationId, @RequestParam MultipartFile file) throws Exception;

    /**
     * 获取用户对话列表-【未过期】
     *
     * @return 返回用户对话列表 - conversation_id
     */
    List<String> getCurrentUserConversationIds() throws Exception;


    /**
     * 大模型对话
     *
     * @param dto
     * @param httpServletResponse
     */
    void communication(@RequestBody AppBuilderCommunicationDto dto, HttpServletResponse httpServletResponse) throws IOException;

}
