package cn.com.poc.appbuilder.service.impl;

import cn.com.poc.appbuilder.model.BizAppbuilderConversationModel;
import cn.com.poc.appbuilder.repository.BizAppbuilderConversationRepository;
import cn.com.poc.appbuilder.service.BizAppbuilderConversationService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Service
public class BizAppbuilderConversationServiceImpl extends BaseServiceImpl
 			 implements BizAppbuilderConversationService {
   
   @Resource
   private BizAppbuilderConversationRepository repository;
    			 
   public BizAppbuilderConversationModel get(Integer id) throws Exception{
       return this.repository.get(id);
   }
    
   public List<BizAppbuilderConversationModel> findByExample(BizAppbuilderConversationModel example, PagingInfo pagingInfo) throws Exception{
       if(example == null){
           example = new BizAppbuilderConversationModel();
       }
       return this.repository.findByExample(example,pagingInfo);
   }
    
   public void delete(BizAppbuilderConversationModel model) throws Exception{
       this.repository.remove(model);
   }
    
   public void deleteById(Integer id) throws Exception{
       this.repository.removeByPk(id);
   }
   
   public void deleteAll(Collection<Integer> ids) throws Exception{
   	   this.repository.removeAllByPk(ids);
   }
    
   public BizAppbuilderConversationModel save(BizAppbuilderConversationModel model) throws Exception{
       return this.repository.save(model);
   }
    
   public Collection<BizAppbuilderConversationModel> saveAll(Collection<BizAppbuilderConversationModel> models) throws Exception{
       return this.repository.saveAll(models);
   }    	
}