package cn.com.poc.approval.aggregate;

import cn.com.poc.approval.constants.ApprovalEnum;
import cn.com.poc.approval.dto.BizApprovalDto;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/27
 */
public interface ApprovalService {

    /**
     * 提交审批单
     *
     * @param approvalType    审核类型
     * @param approvalContent 审批单内容
     * @param userId          用户ID
     * @return 审批单状态
     */
    String submit(ApprovalEnum.ApprovalTypeEnum approvalType, String approvalContent, Long userId);

    /**
     * 更新审批状态
     *
     * @param approvalId             审批单ID
     * @param approvalStatus         审批状态
     * @param approvalProfessionalId 审批人ID
     * @return 审批单状态
     */
    String updateStatus(Long approvalId, ApprovalEnum.ApprovalStatusEnum approvalStatus, Long approvalProfessionalId) throws Exception;

    /**
     * 删除审批单
     *
     * @param approvalId 审批单ID
     * @param userId     用户ID
     */
    void delete(Long approvalId, Long userId) throws Exception;

    /**
     * 获取审批单详情
     *
     * @param approvalId 审批单ID
     * @return 审批单详情
     */
    BizApprovalDto getDetail(Long approvalId) throws Exception;


    /**
     * 获取审批单列表
     *
     * @param userId         用户ID
     * @param approvalType   审批类型
     * @param approvalStatus 审批状态
     * @param pagingInfo     分页信息
     * @return 审批单列表
     */
    List<BizApprovalDto> getList(Long userId, ApprovalEnum.ApprovalTypeEnum approvalType, ApprovalEnum.ApprovalStatusEnum approvalStatus, PagingInfo pagingInfo) throws Exception;

}
