package cn.com.poc.approval.aggregate.impl;

import cn.com.poc.approval.aggregate.ApprovalService;
import cn.com.poc.approval.constants.ApprovalEnum;
import cn.com.poc.approval.convert.BizApprovalConvert;
import cn.com.poc.approval.dto.BizApprovalDto;
import cn.com.poc.approval.entity.BizApprovalEntity;
import cn.com.poc.approval.service.BizApprovalService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.StringUtils;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author alex.yao
 * @date 2025/6/27
 */
@Service
public class ApprovalServiceImpl implements ApprovalService {

    private final Logger logger = LoggerFactory.getLogger(ApprovalService.class);

    private final String PARAM_CODE = "approval.user_id";

    @Resource
    private BizApprovalService bizApprovalService;

    @Resource
    private FmxParamConfigService fmxParamConfigService;

    @Override
    public String submit(ApprovalEnum.ApprovalTypeEnum approvalType, String approvalContent, Long userId) {
        String paramValue = fmxParamConfigService.getParam(PARAM_CODE);
        if (paramValue == null || StringUtils.isBlank(paramValue)) {
            throw new BusinessException("审批人未配置");
        }
        Long approvalProfessionalId = Long.valueOf(paramValue);
        BizApprovalEntity bizApprovalEntity = new BizApprovalEntity();
        bizApprovalEntity.setSubmitter(userId);
        bizApprovalEntity.setApprovalType(approvalType.getCode());
        bizApprovalEntity.setApprovalStatus(ApprovalEnum.ApprovalStatusEnum.APPROVALING.getCode());
        bizApprovalEntity.setApprovalProfessional(approvalProfessionalId);
        bizApprovalEntity.setApprovalContent(approvalContent);
        try {
            bizApprovalService.save(bizApprovalEntity);
        } catch (Exception e) {
            logger.error("Submit Approval Error", e);
            throw new BusinessException("提交审批单失败");
        }
        return ApprovalEnum.ApprovalStatusEnum.APPROVALING.getCode();
    }

    @Override
    public String updateStatus(Long approvalId, ApprovalEnum.ApprovalStatusEnum approvalStatus, Long approvalProfessionalId) throws Exception {
        BizApprovalEntity bizApprovalEntity = bizApprovalService.get(approvalId);
        if (bizApprovalEntity == null) {
            throw new BusinessException("审批单不存在");
        }
        bizApprovalEntity.setApprovalStatus(approvalStatus.getCode());
        bizApprovalEntity.setApprovalProfessional(approvalProfessionalId);
        bizApprovalService.update(bizApprovalEntity);
        return approvalStatus.getCode();
    }

    @Override
    public void delete(Long approvalId, Long userId) throws Exception {

        BizApprovalEntity bizApprovalEntity = bizApprovalService.get(approvalId);
        if (bizApprovalEntity == null) {
            throw new BusinessException("审批单不存在");
        }
        bizApprovalService.deletedById(approvalId);

    }

    @Override
    public BizApprovalDto getDetail(Long approvalId) throws Exception {
        BizApprovalEntity bizApprovalEntity = bizApprovalService.get(approvalId);
        if (bizApprovalEntity == null) {
            throw new BusinessException("审批单不存在");
        }
        return BizApprovalConvert.entityToDto(bizApprovalEntity);
    }

    @Override
    public List<BizApprovalDto> getList(Long userId, ApprovalEnum.ApprovalTypeEnum approvalType, ApprovalEnum.ApprovalStatusEnum approvalStatus, PagingInfo pagingInfo) throws Exception {
        BizApprovalEntity bizApprovalEntity = new BizApprovalEntity();
        if (approvalStatus != null) {
            bizApprovalEntity.setApprovalStatus(approvalStatus.getCode());
        }
        if (approvalType != null) {
            bizApprovalEntity.setApprovalType(approvalType.getCode());
        }
        bizApprovalEntity.setSubmitter(userId);
        bizApprovalEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizApprovalEntity> entities = bizApprovalService.findByExample(bizApprovalEntity, pagingInfo);
        if (CollectionUtils.isNotEmpty(entities)) {
            return entities.stream().map(BizApprovalConvert::entityToDto).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}
