package cn.com.poc.approval.constants;

/**
 * 审批相关常量枚举类
 *
 * @author alex.yao
 * @date 2025/6/27
 */
public class ApprovalEnum {

    /**
     * 审批状态枚举类
     */
    public enum ApprovalStatusEnum {
        /**
         * 审批中
         */
        APPROVALING("APPROVALING", "审批中"),
        /**
         * 审批通过
         */
        APPROVED("APPROVED", "审批通过"),
        /**
         * 审批拒绝
         */
        REJECTED("REJECTED", "审批拒绝");

        private final String code;

        private final String desc;

        ApprovalStatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static ApprovalStatusEnum getEnumByCode(String code) {
            for (ApprovalStatusEnum approvalStatusEnum : ApprovalStatusEnum.values()) {
                if (approvalStatusEnum.getCode().equals(code)) {
                    return approvalStatusEnum;
                }
            }
            return null;
        }
    }

    /**
     * 审批类型枚举类
     */
    public enum ApprovalTypeEnum {
        /**
         * 差旅审批单
         */
        TRAVEL_BUSINESS("TRAVEL_BUSINESS", "差旅审批单"),
        ;

        private final String code;
        private final String desc;

        ApprovalTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static ApprovalTypeEnum getEnumByCode(String code) {
            for (ApprovalTypeEnum approvalTypeEnum : ApprovalTypeEnum.values()) {
                if (approvalTypeEnum.getCode().equals(code)) {
                    return approvalTypeEnum;
                }
            }
            return null;
        }
    }

}
