package cn.com.poc.approval.convert;

import cn.com.poc.approval.model.BizApprovalModel;
import cn.com.poc.approval.entity.BizApprovalEntity;
import cn.com.poc.approval.dto.BizApprovalDto;


public class BizApprovalConvert {

    public static BizApprovalEntity modelToEntity(BizApprovalModel model) {
        BizApprovalEntity entity = new BizApprovalEntity();
        entity.setId(model.getId());
        entity.setSubmitter(model.getSubmitter());
        entity.setApprovalType(model.getApprovalType());
        entity.setApprovalStatus(model.getApprovalStatus());
        entity.setApprovalProfessional(model.getApprovalProfessional());
        entity.setApprovalContent(model.getApprovalContent());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizApprovalModel entityToModel(BizApprovalEntity entity) {
        BizApprovalModel model = new BizApprovalModel();
        model.setId(entity.getId());
        model.setSubmitter(entity.getSubmitter());
        model.setApprovalType(entity.getApprovalType());
        model.setApprovalStatus(entity.getApprovalStatus());
        model.setApprovalProfessional(entity.getApprovalProfessional());
        model.setApprovalContent(entity.getApprovalContent());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizApprovalDto entityToDto(BizApprovalEntity entity) {
        BizApprovalDto dto = new BizApprovalDto();
        dto.setId(entity.getId());
        dto.setSubmitter(entity.getSubmitter());
        dto.setApprovalType(entity.getApprovalType());
        dto.setApprovalStatus(entity.getApprovalStatus());
        dto.setApprovalProfessional(entity.getApprovalProfessional());
        dto.setApprovalContent(entity.getApprovalContent());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifiedTime(entity.getModifiedTime());
        return dto;
    }

    public static BizApprovalEntity dtoToEntity(BizApprovalDto dto) {
        BizApprovalEntity entity = new BizApprovalEntity();
        entity.setId(dto.getId());
        entity.setSubmitter(dto.getSubmitter());
        entity.setApprovalType(dto.getApprovalType());
        entity.setApprovalStatus(dto.getApprovalStatus());
        entity.setApprovalProfessional(dto.getApprovalProfessional());
        entity.setApprovalContent(dto.getApprovalContent());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifiedTime(dto.getModifiedTime());
        return entity;
    }
}