package cn.com.poc.approval.rest;

import cn.com.poc.approval.dto.BizApprovalDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 审批服务接口
 *
 * @author alex.yao
 * @date 2025/6/27
 */
@Permission(Access.Safety)
public interface ApprovalRest extends BaseRest {


    /**
     * 提交审批单
     */
    String submit(@RequestBody BizApprovalDto dto);

    /**
     * 更新审批状态
     */
    String updateStatus(@RequestBody BizApprovalDto dto) throws Exception;

    /**
     * 删除审批单
     */
    void delete(@RequestParam Long approvalId) throws Exception;

    /**
     * 获取审批单详情
     */
    BizApprovalDto getDetail(@RequestParam Long approvalId) throws Exception;


    /**
     * 获取审批单列表
     */
    List<BizApprovalDto> getList(@RequestBody BizApprovalDto dto, PagingInfo pagingInfo) throws Exception;

}
