package cn.com.poc.approval.rest.impl;

import cn.com.poc.approval.aggregate.ApprovalService;
import cn.com.poc.approval.constants.ApprovalEnum;
import cn.com.poc.approval.dto.BizApprovalDto;
import cn.com.poc.approval.rest.ApprovalRest;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/27
 */
@Component
public class ApprovalRestImpl implements ApprovalRest {

    @Resource
    private ApprovalService approvalService;

    @Override
    public String submit(BizApprovalDto dto) {
        Assert.notNull(dto, "approvalDto can not be null");
        Assert.notNull(dto.getApprovalType(), "approvalType can not be null");
        Assert.notNull(dto.getApprovalContent(), "approvalContent can not be null");

        ApprovalEnum.ApprovalTypeEnum approvalType = ApprovalEnum.ApprovalTypeEnum.getEnumByCode(dto.getApprovalType());
        if (approvalType == null) {
            throw new BusinessException("approvalType is not valid");
        }
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return approvalService.submit(approvalType, dto.getApprovalContent(), userBaseEntity.getUserId());
    }

    @Override
    public String updateStatus(BizApprovalDto dto) throws Exception {
        Assert.notNull(dto, "approvalDto can not be null");
        Assert.notNull(dto.getApprovalStatus(), "approval status  can not be null");
        Assert.notNull(dto.getId(), "id can not be null");


        ApprovalEnum.ApprovalStatusEnum approvalStatusEnum = ApprovalEnum.ApprovalStatusEnum.getEnumByCode(dto.getApprovalStatus());
        if (approvalStatusEnum == null) {
            throw new BusinessException("approval status is not valid");
        }
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return approvalService.updateStatus(dto.getId(), approvalStatusEnum, userBaseEntity.getUserId());
    }

    @Override
    public void delete(Long approvalId) throws Exception {
        Assert.notNull(approvalId, "approvalId can not be null");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        approvalService.delete(approvalId, userBaseEntity.getUserId());
    }

    @Override
    public BizApprovalDto getDetail(Long approvalId) throws Exception {
        Assert.notNull(approvalId, "approvalId can not be null");
        return approvalService.getDetail(approvalId);
    }

    @Override
    public List<BizApprovalDto> getList(BizApprovalDto dto, PagingInfo pagingInfo) throws Exception {
        Assert.notNull(dto, "approvalDto can not be null");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        ApprovalEnum.ApprovalTypeEnum approvalTypeEnum = null;
        ApprovalEnum.ApprovalStatusEnum approvalStatusEnum = null;
        if (StringUtils.isNotBlank(dto.getApprovalType())) {
            approvalTypeEnum = ApprovalEnum.ApprovalTypeEnum.getEnumByCode(dto.getApprovalType());
        }
        if (StringUtils.isNotBlank(dto.getApprovalStatus())) {
            approvalStatusEnum = ApprovalEnum.ApprovalStatusEnum.getEnumByCode(dto.getApprovalStatus());
        }

        return approvalService.getList(userBaseEntity.getUserId(), approvalTypeEnum, approvalStatusEnum, pagingInfo);
    }
}
