package cn.com.poc.approval.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.approval.service.BizApprovalService;
import cn.com.poc.approval.model.BizApprovalModel;
import cn.com.poc.approval.entity.BizApprovalEntity;
import cn.com.poc.approval.convert.BizApprovalConvert;
import cn.com.poc.approval.repository.BizApprovalRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizApprovalServiceImpl extends BaseServiceImpl
        implements BizApprovalService {

    @Resource
    private BizApprovalRepository repository;

    public BizApprovalEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizApprovalModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizApprovalConvert.modelToEntity(model);
    }


    public List<BizApprovalEntity> findByExample(BizApprovalEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizApprovalEntity> result = new ArrayList<BizApprovalEntity>();
        BizApprovalModel model = new BizApprovalModel();
        if (example != null) {
            model = BizApprovalConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizApprovalModel> models = this.repository.findByExample(model, "id desc", pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizApprovalConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizApprovalEntity save(BizApprovalEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizApprovalModel model = BizApprovalConvert.entityToModel(entity);
        BizApprovalModel saveModel = this.repository.save(model);
        return BizApprovalConvert.modelToEntity(saveModel);
    }

    public BizApprovalEntity update(BizApprovalEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizApprovalModel model = this.repository.get(entity.getId());

        if (entity.getSubmitter() != null) {
            model.setSubmitter(entity.getSubmitter());
        }
        if (entity.getApprovalType() != null) {
            model.setApprovalType(entity.getApprovalType());
        }
        if (entity.getApprovalStatus() != null) {
            model.setApprovalStatus(entity.getApprovalStatus());
        }
        if (entity.getApprovalProfessional() != null) {
            model.setApprovalProfessional(entity.getApprovalProfessional());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizApprovalModel saveModel = this.repository.save(model);
        return BizApprovalConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizApprovalModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}