package cn.com.poc.common.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_file_upload_record
 * 文件上传记录
 */
@Entity
@Table(name = "biz_file_upload_record")
@DynamicInsert
@DynamicUpdate
public class BizFileUploadRecordModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 主键
     */
    private Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * file_name
     * 文件名
     */
    private String fileName;

    @Column(name = "file_name", length = 150)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        super.addValidField("fileName");
    }


    /**
     * file_url
     * 上传地址
     */
    private String fileUrl;

    @Column(name = "file_url", length = 150)
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }


    /**
     * cover_sheet_url
     * 封面图地址
     */
    private String coverSheetUrl;

    @Column(name = "cover_sheet_url", length = 150)
    public String getCoverSheetUrl() {
        return this.coverSheetUrl;
    }

    public void setCoverSheetUrl(String coverSheetUrl) {
        this.coverSheetUrl = coverSheetUrl;
        super.addValidField("coverSheetUrl");
    }

    /**
     * md5
     */
    private String md5;

    @Column(name = "md5", length = 128)
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
        super.addValidField("md5");
    }
}