package cn.com.poc.common.rest.impl;

import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.rest.JudgeCodeRest;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class JudgeCodeRestImpl implements JudgeCodeRest {

        @Resource
        private JudgeCodeService judgeCodeService;

        @Override
        public boolean judgeCode(String account, String code) throws Exception {
            Assert.notBlank(account);
            Assert.notBlank(code);
            return judgeCodeService.judgeCode(account, code);
        }

        @Override
        public String judgeCodeReturnAuthCode(String account, String code) throws Exception {
            Assert.notBlank(account);
            Assert.notBlank(code);
            return judgeCodeService.judgeCodeReturnAuthCode(account, code);
        }
}
