package cn.com.poc.common.segmentation;


import cn.com.poc.common.segmentation.contents.SegmentationEnum;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;

/**
 * @author alex
 */
public class SegmentationBuilder {

    private String content;

    private String documentUrl;

    private String documentName;

    private String segmentationType;

    public SegmentationBuilder content(String content) {
        this.content = content;
        return this;
    }

    public SegmentationBuilder documentUrl(String documentUrl) {
        this.documentUrl = documentUrl;
        return this;
    }

    public SegmentationBuilder documentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    public SegmentationBuilder segmentationType(String segmentationType) {
        this.segmentationType = segmentationType;
        return this;
    }


    public SegmentationAbstract build() {
        try {
            if (StringUtils.isBlank(this.documentUrl) && StringUtils.isBlank(content)) {
                throw new BusinessException("文本分割器不能为空");
            }
            if (StringUtils.isBlank(this.segmentationType)) {
                throw new BusinessException("文本分割器类型不能为空");
            }

            Class<? extends SegmentationAbstract> segmentationClass = SegmentationEnum.matchSegmentationClass(this.segmentationType);
            if (segmentationClass == null) {
                throw new BusinessException("未找到该类型文本分割器");
            }
            SegmentationAbstract segmentationAbstract = segmentationClass.newInstance();
            segmentationAbstract.setDocumentUrl(this.documentUrl);
            segmentationAbstract.setContent(this.content);
            segmentationAbstract.setDocumentName(this.documentName);
            return segmentationAbstract;
        } catch (InstantiationException | IllegalAccessException e) {
            throw new BusinessException("文本分割器初始化失败");
        }
    }

}
