package cn.com.poc.common.segmentation.contents;


import cn.com.poc.common.segmentation.DefaultSegmentation;
import cn.com.poc.common.segmentation.NumberOfWordSegmentation;
import cn.com.poc.common.segmentation.SegmentationAbstract;

/**
 * 内容分片枚举
 *
 * @author alex.yao
 */

public enum SegmentationEnum {

    /**
     * 默认-分片大小
     */
    DEFAULT(DefaultSegmentation.class),

    /**
     * 按字数
     */
    NUMBER_Of_WORDS(NumberOfWordSegmentation.class),

    ;

    private final Class<? extends SegmentationAbstract> clazz;

    SegmentationEnum(Class<? extends SegmentationAbstract> clazz) {
        this.clazz = clazz;
    }

    public static Class<? extends SegmentationAbstract> matchSegmentationClass(String type) {
        for (SegmentationEnum segmentation : SegmentationEnum.values()) {
            if (segmentation.name().equalsIgnoreCase(type)) {
                return segmentation.clazz;
            }
        }
        return null;
    }
}
