package cn.com.poc.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class WeChatUtil {

    public static Long dateDiff(String startTime, String endTime, String format, String str) {
        // 按照传入的格式生成一个simpledateformate对象
        SimpleDateFormat sd = new SimpleDateFormat(format);
        // long nd = 1000 * 24 * 60 * 60;// 一天的毫秒数
        // long nh = 1000 * 60 * 60;// 一小时的毫秒数
        // long nm = 1000 * 60;// 一分钟的毫秒数
        long ns = 1000;// 一秒钟的毫秒数
        long diff = 0;
        // long day = 0;
        // long hour = 0;
        // long min = 0;
        // long sec = 0;
        long s = 0;
        // 获得两个时间的毫秒时间差异
        try {
            diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
            // day = diff / nd;// 计算差多少天
            // hour = diff % nd / nh + day * 24;// 计算差多少小时
            // min = diff % nd % nh / nm + day * 24 * 60;// 计算差多少分钟
            // sec = diff % nd % nh % nm / ns;// 计算差多少秒
            s = diff / ns; // 总共所有的秒数
            // 输出结果
            // System.out.println("时间相差：" + day + "天" + (hour - day * 24) + "小时"
            // + (min - day * 24 * 60) + "分钟" + sec + "秒。");
            // System.out.println("hour=" + hour + ",min=" + min);

            if ("s".equals(str)) {
                return s;
            } else {
                return s;
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        if ("s".equals(str)) {
            return s;
        } else {
            return s;
        }
    }

    public static String SHA1(String decript) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");

            digest.update(decript.getBytes(StandardCharsets.UTF_8));

            byte[] messageDigest = digest.digest();
            // Create Hex String
            StringBuilder hexString = new StringBuilder();
            // 字节数组转换为 十六进制 数
            for (byte b : messageDigest) {
                String shaHex = Integer.toHexString(b & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

}
