package cn.com.poc.covenant.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_extraction_key_info_config
 * TextIn 合同要素抽取 关键信息配置
 */
@Entity
@Table(name = "biz_extraction_key_info_config")
@DynamicInsert
@DynamicUpdate
public class BizExtractionKeyInfoConfigModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     */
    private Integer id;

    @Column(name = "id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * key_info
     * 关键信息名称, 长度限制20个字符
     */
    private String keyInfo;

    @Column(name = "key_info", length = 20)
    public String getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(String keyInfo) {
        this.keyInfo = keyInfo;
        super.addValidField("keyInfo");
    }


    /**
     * paraphrase_names
     * 相似名字段,字符串数组, 可根据相似名精准抽取关键信息, 最多填写3个,每个释义名称长度限制20个字符  [array]
     */
    private String paraphraseNames;

    @Column(name = "paraphrase_names", length = 1073741824)
    public String getParaphraseNames() {
        return this.paraphraseNames;
    }

    public void setParaphraseNames(String paraphraseNames) {
        this.paraphraseNames = paraphraseNames;
        super.addValidField("paraphraseNames");
    }


    /**
     * field_type
     * 字段类型字段, 可选项有,时间:time, 金额:amount, 地址:address, 公司:company, 姓名:name, 描述(长文本):long_text_description, 其他:other, 印章:stamp, 分别对应产品段配置的字段类型
     */
    private String fieldType;

    @Column(name = "field_type", length = 10)
    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
        super.addValidField("fieldType");
    }


    /**
     * is_in_table
     * 位于表格字段, 抽取内容是否位于表格内，若不确定可不填写
     */
    private String isInTable;

    @Column(name = "is_in_table", length = 1)
    public String getIsInTable() {
        return this.isInTable;
    }

    public void setIsInTable(String isInTable) {
        this.isInTable = isInTable;
        super.addValidField("isInTable");
    }


    /**
     * keywords
     * 关键字字段, 字符串数组, 可根据关键字信息，快速定位抽取信所在段落范围, 最多填写10个,且字符总长度不超过50 [array]
     */
    private String keywords;

    @Column(name = "keywords", length = 1073741824)
    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
        super.addValidField("keywords");
    }


    /**
     * 合同类型
     */
    private String contractType;

    @Column(name = "contract_type", length = 100)
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
        super.addValidField("contractType");
    }
}