package cn.com.poc.covenant.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_extraction_review_task
 * 合同审查任务
 */
@Entity
@Table(name = "biz_extraction_review_task")
@DynamicInsert
@DynamicUpdate
public class BizExtractionReviewTaskModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     */
    private Integer id;

    @Column(name = "id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * task_id
     * 审查任务
     */
    private String taskId;

    @Column(name = "task_id", length = 100)
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        super.addValidField("taskId");
    }

    /**
     * user_id
     * 用户ID
     */
    private Long userId;

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
        super.addValidField("userId");
    }


    /**
     * file_url
     * 文件地址
     */
    private String fileUrl;

    @Column(name = "file_url", length = 120)
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }


    /**
     * file_name
     * 文件名
     */
    private String fileName;

    @Column(name = "file_name", length = 100)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        super.addValidField("fileName");
    }


    /**
     * actionType
     * 执行动作（审查，提取，对比）
     */
    private String actionType;

    @Column(name = "action_type", length = 100)
    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
        super.addValidField("actionType");
    }


    /**
     * review_status
     * 审核状态  RUN-审核中 END-已完成 FAIL-审核失败
     */
    private String reviewStatus;

    @Column(name = "review_status", length = 10)
    public String getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(String reviewStatus) {
        this.reviewStatus = reviewStatus;
        super.addValidField("reviewStatus");
    }


    /**
     * review_error_msg
     * 审核异常消息
     */
    private String reviewErrorMsg;

    @Column(name = "review_error_msg", length = 300)
    public String getReviewErrorMsg() {
        return this.reviewErrorMsg;
    }

    public void setReviewErrorMsg(String reviewErrorMsg) {
        this.reviewErrorMsg = reviewErrorMsg;
        super.addValidField("reviewErrorMsg");
    }


    /**
     * text_in_task_id
     * textIn的task_id
     */
    private String textInTaskId;

    @Column(name = "text_in_task_id", length = 120)
    public String getTextInTaskId() {
        return this.textInTaskId;
    }

    public void setTextInTaskId(String textInTaskId) {
        this.textInTaskId = textInTaskId;
        super.addValidField("textInTaskId");
    }


    /**
     * contract_type
     * 合同类型
     */
    private String contractType;

    @Column(name = "contract_type", length = 100)
    public String getContractType() {
        return this.contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
        super.addValidField("contractType");
    }


    /**
     * is_deleted
     * 是否删除 1、Y 是 2、N 否
     */
    private String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    @Column(name = "CREATOR", length = 225)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private String modifier;

    @Column(name = "MODIFIER", length = 225)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}