package cn.com.poc.covenant.rest;

import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.poc.covenant.dto.BizExtractionDocFlowDto;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.Collection;
import java.util.List;

import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Permission(Access.Safety)
public interface BizExtractionDocFlowRest extends BaseRest {

    /**
     * 根据任务输入ID获取业务提取文档流程数据传输对象
     *
     * @param taskInId 任务输入ID，用于唯一标识一个任务输入
     * @return BizExtractionDocFlowDto 业务提取文档流程数据传输对象
     * @throws Exception 当获取过程中发生异常时抛出
     */
    BizExtractionDocFlowDto getByTaskInId(@RequestParam String taskInId) throws Exception;

    /**
     * 更新业务提取文档流程数据传输对象
     *
     * @param bizExtractionDocFlowDto 业务提取文档流程数据传输对象
     * @return BizExtractionDocFlowDto 业务提取文档流程数据传输对象
     * @throws Exception 当更新过程中发生异常时抛出
     */
    BizExtractionDocFlowDto update(@RequestBody BizExtractionDocFlowDto bizExtractionDocFlowDto) throws Exception;

    /**
     * @param bizTextInTaskId
     * @return
     * @throws Exception
     */
    String report(String bizTextInTaskId) throws Exception;


}