package cn.com.poc.covenant.rest;

import cn.com.poc.covenant.dto.ExtractionDto;
import cn.com.poc.covenant.dto.ReviewProgressDto;
import cn.com.poc.covenant.dto.StartDocFlowDto;
import cn.com.poc.covenant.dto.StartReviewDto;
import cn.com.poc.covenant.model.BizExtractionReviewTaskModel;
import cn.com.poc.covenant.model.BizExtreactionContractTypeModel;
import cn.com.poc.thirdparty.resource.text_in.entity.doc_flow.FileUploadResponse;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * 合同要素抽取服务
 *
 * @author alex.yao
 * @date 2025/5/19
 */
@Permission(Access.Safety)
public interface ExtractionRest extends BaseRest {

    /**
     * 开始合同抽取
     */
    String startExtract(@RequestBody StartReviewDto startReviewDto) throws Exception;

    /**
     * 开始合同审查
     */
    String startReview(@RequestBody StartReviewDto startReviewDto) throws Exception;

    /**
     * 开始单据提取-textin docflow
     * https://docflow.apifox.cn/
     */
    String startDocFlow(@RequestBody StartDocFlowDto startDocFlowDto) throws Exception;

    /**
     * 获取合同类型列表
     */
    @Permission(Access.Anonymous)
    List<BizExtreactionContractTypeModel> getContractTypeList(@RequestParam String contractType) throws Exception;

    /**
     * 获取审核进度详情-列表
     */
    List<ReviewProgressDto> reviewProgressList(@RequestParam String reviewTaskId, @RequestParam String search, @RequestParam String actionType);


    /**
     * 获取合同要素抽取结果
     *
     * @param taskId 任务ID
     */
    ExtractionDto getResult(@RequestParam String taskId);

    /**
     * @param taskId 任务ID
     * @return
     */
    String getReviewUrl(@RequestParam String taskId) throws Exception;

    FileUploadResponse createDocFlowTask(MultipartFile multipartFile, String workspaceid, String category) throws IOException;

    BizExtractionReviewTaskModel getReviewTaskByTextInTaskId(@RequestParam String textInTaskId) throws Exception;

}
