package cn.com.poc.covenant.rest;

import cn.com.poc.covenant.dto.StartTextDiffDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * 合同对比服务接口
 *
 * @author alex.yao
 * @date 2025/6/25
 */
@Permission(Access.Safety)
public interface TextDiffRest extends BaseRest {

    /**
     * 文本对比
     *
     * @param baseFile    主版文件
     * @param compareFile 副版文件
     * @return 任务ID
     */
    String textDiff(@RequestParam MultipartFile baseFile, @RequestParam MultipartFile compareFile);


    /**
     * 文本对比
     *
     * @param startTextDiffDto 对比参数
     * @return 任务ID
     */
    String textDiffByUrl(@RequestBody StartTextDiffDto startTextDiffDto);


    /**
     * 获取前端SDK渲染地址
     *
     * @param taskId 任务ID
     * @return 渲染地址
     */
    String getRenderUrl(@RequestParam String taskId);

    /**
     * 查询任务状态
     *
     * @param taskId 任务ID
     * @return 任务状态 RUN-执行中 FAIL-失败 END-执行成功
     */
    String queryTextDiffTask(@RequestParam String taskId) throws Exception;

}

