package cn.com.poc.covenant.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.covenant.aggregate.LegalAffairsDialoguesService;
import cn.com.poc.covenant.dto.LegalAffairsDialoguesDto;
import cn.com.poc.covenant.rest.LegalAffairsRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/27
 */
@Component
public class LegalAffairsRestImpl implements LegalAffairsRest {

    @Resource
    private LegalAffairsDialoguesService legalAffairsDialoguesService;

    @Override
    public void call(LegalAffairsDialoguesDto legalAffairsDialoguesDto) throws Exception {
        Assert.notNull(legalAffairsDialoguesDto);
        Assert.notBlank(legalAffairsDialoguesDto.getInput());
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        legalAffairsDialoguesService.call(
                legalAffairsDialoguesDto.getDialoguesId(),
                legalAffairsDialoguesDto.getInput(),
                legalAffairsDialoguesDto.getFileUrl(),
                legalAffairsDialoguesDto.getKnowledgeIds(),
                legalAffairsDialoguesDto.getDatabaseIds(),
                userBaseEntity.getUserId());
    }
}
