package cn.com.poc.covenant.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.FileUtils;
import cn.com.poc.covenant.dto.StartTextDiffDto;
import cn.com.poc.covenant.rest.TextDiffRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.baidu.entity.response.text_diff.BaiduTextDiffQueryResult;
import cn.com.poc.thirdparty.resource.baidu.service.BaiduTextDiffService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/25
 */
@Component
public class TextDiffRestImpl implements TextDiffRest {

    @Resource
    private BaiduTextDiffService baiduTextDiffService;

    @Override
    public String textDiff(MultipartFile baseFile, MultipartFile compareFile) {
        Assert.notNull(baseFile, "Base file cannot be null");
        Assert.notNull(compareFile, "Compare file cannot be null");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity != null) {
            throw new BusinessException("用户未登录");
        }
        return baiduTextDiffService.textDiff(FileUtils.multipartFileToFile(baseFile), FileUtils.multipartFileToFile(compareFile), null, userBaseEntity.getUserId());
    }

    @Override
    public String textDiffByUrl(StartTextDiffDto startTextDiffDto) {
        Assert.notNull(startTextDiffDto, "Start text diff DTO cannot be null");
        Assert.notNull(startTextDiffDto.getBaseFileURL(), "Base file cannot be null");
        Assert.notNull(startTextDiffDto.getCompareFileURL(), "Compare file cannot be null");
        Assert.notNull(startTextDiffDto.getParam(), "Param cannot be null");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return baiduTextDiffService.textDiff(startTextDiffDto.getBaseFileURL(), startTextDiffDto.getCompareFileURL(), startTextDiffDto.getParam(), userBaseEntity.getUserId());
    }


    @Override
    public String getRenderUrl(String taskId) {
        Assert.notBlank(taskId, "Task ID cannot be blank");
        return baiduTextDiffService.getSDKUrl(taskId);
    }

    @Override
    public String queryTextDiffTask(String taskId) throws Exception {
        Assert.notBlank(taskId, "Task ID cannot be blank");
        return baiduTextDiffService.queryTextDiffTask(taskId);
    }
}
