package cn.com.poc.covenant.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.covenant.service.BizExtractionDocFlowService;
import cn.com.poc.covenant.model.BizExtractionDocFlowModel;
import cn.com.poc.covenant.entity.BizExtractionDocFlowEntity;
import cn.com.poc.covenant.convert.BizExtractionDocFlowConvert;
import cn.com.poc.covenant.repository.BizExtractionDocFlowRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizExtractionDocFlowServiceImpl extends BaseServiceImpl
 			 implements BizExtractionDocFlowService {
   
   @Resource
   private BizExtractionDocFlowRepository repository;
    			 
   public BizExtractionDocFlowEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizExtractionDocFlowModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizExtractionDocFlowConvert.modelToEntity(model);
   }

   public List<BizExtractionDocFlowEntity> findByExample(BizExtractionDocFlowEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizExtractionDocFlowEntity> result = new  ArrayList<BizExtractionDocFlowEntity>();
        BizExtractionDocFlowModel model = new BizExtractionDocFlowModel();
        if (example != null){
            model = BizExtractionDocFlowConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizExtractionDocFlowModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizExtractionDocFlowConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizExtractionDocFlowEntity save(BizExtractionDocFlowEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setBizExtractionDocFlowId(null);
        entity.setIsDeleted("N");
        BizExtractionDocFlowModel model = BizExtractionDocFlowConvert.entityToModel(entity);
        BizExtractionDocFlowModel saveModel =  this.repository.save(model);
        return BizExtractionDocFlowConvert.modelToEntity(saveModel);
    }

    public BizExtractionDocFlowEntity update(BizExtractionDocFlowEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getBizExtractionDocFlowId(),"update pk can not be null");
        BizExtractionDocFlowModel model = this.repository.get(entity.getBizExtractionDocFlowId());

       if (entity.getBizTextInTaskId() != null){
        model.setBizTextInTaskId(entity.getBizTextInTaskId());
       }
       if (entity.getBizDocFlowStamps() != null){
        model.setBizDocFlowStamps(entity.getBizDocFlowStamps());
       }
       if (entity.getBizDocFlowTables() != null){
        model.setBizDocFlowTables(entity.getBizDocFlowTables());
       }
       if (entity.getBizDocFlowFields() != null){
        model.setBizDocFlowFields(entity.getBizDocFlowFields());
       }
       if (entity.getBizDocFlowHandwritings() != null){
        model.setBizDocFlowHandwritings(entity.getBizDocFlowHandwritings());
       }
       if (entity.getBizDocFlowItems() != null){
        model.setBizDocFlowItems(entity.getBizDocFlowItems());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizExtractionDocFlowModel saveModel =  this.repository.save(model);
        return BizExtractionDocFlowConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizExtractionDocFlowModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}