package cn.com.poc.covenant.service.impl;

import cn.com.poc.covenant.model.BizExtractionKeyInfoConfigModel;
import cn.com.poc.covenant.repository.BizExtractionKeyInfoConfigRepository;
import cn.com.poc.covenant.service.BizExtractionKeyInfoConfigService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Service
public class BizExtractionKeyInfoConfigServiceImpl extends BaseServiceImpl
 			 implements BizExtractionKeyInfoConfigService {
   
   @Resource
   private BizExtractionKeyInfoConfigRepository repository;
    			 
   public BizExtractionKeyInfoConfigModel get(Integer id) throws Exception{
       return this.repository.get(id);
   }
    
   public List<BizExtractionKeyInfoConfigModel> findByExample(BizExtractionKeyInfoConfigModel example,PagingInfo pagingInfo) {
       if(example == null){
           example = new BizExtractionKeyInfoConfigModel();
       }
       return this.repository.findByExample(example,pagingInfo);
   }
    
   public void delete(BizExtractionKeyInfoConfigModel model) throws Exception{
       this.repository.remove(model);
   }
    
   public void deleteById(Integer id) throws Exception{
       this.repository.removeByPk(id);
   }
   
   public void deleteAll(Collection<Integer> ids) throws Exception{
   	   this.repository.removeAllByPk(ids);
   }
    
   public BizExtractionKeyInfoConfigModel save(BizExtractionKeyInfoConfigModel model) throws Exception{
       return this.repository.save(model);
   }
    
   public Collection<BizExtractionKeyInfoConfigModel> saveAll(Collection<BizExtractionKeyInfoConfigModel> models) throws Exception{
       return this.repository.saveAll(models);
   }    	
}