package cn.com.poc.covenant.service.impl;

import cn.com.poc.covenant.model.BizExtractionReviewTaskModel;
import cn.com.poc.covenant.query.ExtractionTaskQueryCondition;
import cn.com.poc.covenant.query.ExtractionTaskQueryItem;
import cn.com.poc.covenant.repository.BizExtractionReviewTaskRepository;
import cn.com.poc.covenant.service.BizExtractionReviewTaskService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Service
public class BizExtractionReviewTaskServiceImpl extends BaseServiceImpl
        implements BizExtractionReviewTaskService {

    @Resource
    private BizExtractionReviewTaskRepository repository;

    public BizExtractionReviewTaskModel get(Integer id) throws Exception {
        return this.repository.get(id);
    }

    public List<BizExtractionReviewTaskModel> findByExample(BizExtractionReviewTaskModel example, PagingInfo pagingInfo) throws Exception {
        if (example == null) {
            example = new BizExtractionReviewTaskModel();
        }
        return this.repository.findByExample(example, pagingInfo);
    }

    public void delete(BizExtractionReviewTaskModel model) throws Exception {
        this.repository.remove(model);
    }

    public void deleteById(Integer id) throws Exception {
        this.repository.removeByPk(id);
    }

    public void deleteAll(Collection<Integer> ids) throws Exception {
        this.repository.removeAllByPk(ids);
    }

    public BizExtractionReviewTaskModel save(BizExtractionReviewTaskModel model) throws Exception {
        return this.repository.save(model);
    }

    public Collection<BizExtractionReviewTaskModel> saveAll(Collection<BizExtractionReviewTaskModel> models) throws Exception {
        return this.repository.saveAll(models);
    }

    @Override
    public List<ExtractionTaskQueryItem> extractionTaskQuery(ExtractionTaskQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, ExtractionTaskQueryItem.class, pagingInfo);
    }
}