SELECT
    COUNT(DISTINCT CASE WHEN DATE(datetime) = CURDATE() THEN member_id END) AS today_dialogue_member,
    COUNT(CASE WHEN DATE(datetime) = CURDATE() THEN 1 END) AS today_dialogue,    
    COUNT(DISTINCT CASE WHEN DATE(datetime) = CURDATE() - INTERVAL 1 DAY THEN member_id END) AS yesterday_dialogue_member,
    COUNT(CASE WHEN DATE(datetime) = CURDATE() - INTERVAL 1 DAY THEN 1 END) AS yesterday_dialogue,    
    COUNT(DISTINCT CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE(), 1) THEN member_id END) AS week_dialogue_member,
    COUNT(CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE(), 1) THEN 1 END) AS week_dialogue,    
    COUNT(DISTINCT CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE() - INTERVAL 1 WEEK, 1) THEN member_id END) AS last_week_dialogue_member,
    COUNT(CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE() - INTERVAL 1 WEEK, 1) THEN 1 END) AS last_week_dialogue,
    COUNT(DISTINCT CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE) AND MONTH(datetime) = MONTH(CURRENT_DATE) THEN member_id END) AS month_dialogue_member,
    COUNT(CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE) AND MONTH(datetime) = MONTH(CURRENT_DATE) THEN 1 END) AS month_dialogue,
    COUNT(DISTINCT CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) AND MONTH(datetime) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) THEN member_id END) AS last_month_dialogue_member,
    COUNT(CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) AND MONTH(datetime) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) THEN 1 END) AS last_month_dialogue
FROM biz_data_analyze_dialogue_record 
where 1 = 1 
<<and relation_id = :relationId>>
<<and channel in (:channels)>>
GROUP BY relation_id