select *
from (select bmi.nick_name                                                           as owner,
             baai.agent_title,
             count(bdadr.relation_id)                                                as usage_count,
             ifnull(sum(bdadr.point_num), 0)                                         as total_points,
             max(bdadr.datetime)                                                     as last_usage_time,
             (case when baai.agent_publish_status = "publish" then "Y" else "N" end) as publish_status
      from biz_data_analyze_dialogue_record bdadr
               left join biz_agent_application_info baai on baai.agent_id = bdadr.relation_id
               left join biz_member_info bmi on bmi.member_id = baai.member_id
      where 1=1
          <<  and bdadr.member_id = :memberId>>
      group by bdadr.relation_id, bdadr.member_id) as t1
where 1 = 1 << and t1.last_usage_time >= :startDate and t1.last_usage_time <=  :endDate >>
order by t1.last_usage_time desc