package cn.com.poc.data_analyze.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.data_analyze.service.BizDataAnalyzeCollectService;
import cn.com.poc.data_analyze.model.BizDataAnalyzeCollectModel;
import cn.com.poc.data_analyze.entity.BizDataAnalyzeCollectEntity;
import cn.com.poc.data_analyze.convert.BizDataAnalyzeCollectConvert;
import cn.com.poc.data_analyze.repository.BizDataAnalyzeCollectRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizDataAnalyzeCollectServiceImpl extends BaseServiceImpl
 			 implements BizDataAnalyzeCollectService {
   
   @Resource
   private BizDataAnalyzeCollectRepository repository;
    			 
   public BizDataAnalyzeCollectEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizDataAnalyzeCollectModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizDataAnalyzeCollectConvert.modelToEntity(model);
   }

       
   public List<BizDataAnalyzeCollectEntity> findByExample(BizDataAnalyzeCollectEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizDataAnalyzeCollectEntity> result = new  ArrayList<BizDataAnalyzeCollectEntity>();
        BizDataAnalyzeCollectModel model = new BizDataAnalyzeCollectModel();
        if (example != null){
            model = BizDataAnalyzeCollectConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizDataAnalyzeCollectModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizDataAnalyzeCollectConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizDataAnalyzeCollectEntity save(BizDataAnalyzeCollectEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizDataAnalyzeCollectModel model = BizDataAnalyzeCollectConvert.entityToModel(entity);
        BizDataAnalyzeCollectModel saveModel =  this.repository.save(model);
        return BizDataAnalyzeCollectConvert.modelToEntity(saveModel);
    }

    public BizDataAnalyzeCollectEntity update(BizDataAnalyzeCollectEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizDataAnalyzeCollectModel model = this.repository.get(entity.getId());

       if (entity.getRelationId() != null){
        model.setRelationId(entity.getRelationId());
       }
       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getChannel() != null){
        model.setChannel(entity.getChannel());
       }
       if (entity.getTotalPoints() != null){
        model.setTotalPoints(entity.getTotalPoints());
       }
       if (entity.getUsageCount() != null){
        model.setUsageCount(entity.getUsageCount());
       }
       if (entity.getUsersCount() != null){
        model.setUsersCount(entity.getUsersCount());
       }
       if (entity.getDataDate() != null){
        model.setDataDate(entity.getDataDate());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizDataAnalyzeCollectModel saveModel =  this.repository.save(model);
        return BizDataAnalyzeCollectConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizDataAnalyzeCollectModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}