package cn.com.poc.equity.aggregate;

import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.domain.AgentEquity;
import cn.com.poc.equity.entity.BizPaymentPackageConfigurationEntity;
import cn.com.poc.equity.entity.CurrentUserPayOrderEntity;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

public interface EquityService {

    /**
     * 获取权益包信息
     *
     * @param type 类型 normal-普通 professional-专业版 ， ultimate-旗舰版
     * @return
     */
    List<AgentEquity> getEquityList(EquityEnum.TYPE type);

    /**
     * 获取积分包信息
     */
    List<BizPaymentPackageConfigurationEntity> getPointList();

    /**
     * 创建权益支付订单
     *
     * @param type         权益类型
     * @param domain       权益域
     * @param validityUnit 有效期单位
     * @param memberID     会员ID
     * @return 订单号
     */
    String createEquityOrder(EquityEnum.TYPE type, EquityEnum.DOMAIN domain, EquityEnum.VALIDITY_UNIT validityUnit, Long memberID) throws Exception;

    /**
     * 获取用户订单列表
     *
     * @param memberId 会员ID
     * @param domain   权益域
     * @return 订单列表
     */
    List<CurrentUserPayOrderEntity> getUserOrderList(Long memberId, EquityEnum.DOMAIN domain, PagingInfo pagingInfo);

}
