package cn.com.poc.equity.convert;	

import cn.com.poc.equity.model.BizPointDeductionRulesModel;
import cn.com.poc.equity.entity.BizPointDeductionRulesEntity;
import cn.com.poc.equity.dto.BizPointDeductionRulesDto;


public class BizPointDeductionRulesConvert {

    public static BizPointDeductionRulesEntity modelToEntity(BizPointDeductionRulesModel model){
        BizPointDeductionRulesEntity entity = new BizPointDeductionRulesEntity();
        entity.setId(model.getId());
        entity.setRuleType(model.getRuleType());
        entity.setDedctionRule(model.getDedctionRule());
        entity.setRelationId(model.getRelationId());
        entity.setNumber(model.getNumber());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizPointDeductionRulesModel entityToModel(BizPointDeductionRulesEntity entity){
        BizPointDeductionRulesModel model = new BizPointDeductionRulesModel();
        model.setId(entity.getId());
        model.setRuleType(entity.getRuleType());
        model.setDedctionRule(entity.getDedctionRule());
        model.setRelationId(entity.getRelationId());
        model.setNumber(entity.getNumber());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }
    
    public static BizPointDeductionRulesDto entityToDto(BizPointDeductionRulesEntity entity){
        BizPointDeductionRulesDto dto = new BizPointDeductionRulesDto();
        dto.setId(entity.getId());
        dto.setRuleType(entity.getRuleType());
        dto.setDedctionRule(entity.getDedctionRule());
        dto.setRelationId(entity.getRelationId());
        dto.setNumber(entity.getNumber());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizPointDeductionRulesEntity dtoToEntity(BizPointDeductionRulesDto dto){
        BizPointDeductionRulesEntity entity = new BizPointDeductionRulesEntity();
        entity.setId(dto.getId());
        entity.setRuleType(dto.getRuleType());
        entity.setDedctionRule(dto.getDedctionRule());
        entity.setRelationId(dto.getRelationId());
        entity.setNumber(dto.getNumber());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }
}