package cn.com.poc.equity.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.equity.service.BizPointDeductionRulesService;
import cn.com.poc.equity.model.BizPointDeductionRulesModel;
import cn.com.poc.equity.entity.BizPointDeductionRulesEntity;
import cn.com.poc.equity.convert.BizPointDeductionRulesConvert;
import cn.com.poc.equity.repository.BizPointDeductionRulesRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizPointDeductionRulesServiceImpl extends BaseServiceImpl
 			 implements BizPointDeductionRulesService {
   
   @Resource
   private BizPointDeductionRulesRepository repository;
    			 
   public BizPointDeductionRulesEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizPointDeductionRulesModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizPointDeductionRulesConvert.modelToEntity(model);
   }

       
   public List<BizPointDeductionRulesEntity> findByExample(BizPointDeductionRulesEntity example,PagingInfo pagingInfo){
        List<BizPointDeductionRulesEntity> result = new  ArrayList<BizPointDeductionRulesEntity>();
        BizPointDeductionRulesModel model = new BizPointDeductionRulesModel();
        if (example != null){
            model = BizPointDeductionRulesConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizPointDeductionRulesModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizPointDeductionRulesConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizPointDeductionRulesEntity save(BizPointDeductionRulesEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizPointDeductionRulesModel model = BizPointDeductionRulesConvert.entityToModel(entity);
        BizPointDeductionRulesModel saveModel =  this.repository.save(model);
        return BizPointDeductionRulesConvert.modelToEntity(saveModel);
    }

    public BizPointDeductionRulesEntity update(BizPointDeductionRulesEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizPointDeductionRulesModel model = this.repository.get(entity.getId());

       if (entity.getRuleType() != null){
        model.setRuleType(entity.getRuleType());
       }
       if (entity.getDedctionRule() != null){
        model.setDedctionRule(entity.getDedctionRule());
       }
       if (entity.getRelationId() != null){
        model.setRelationId(entity.getRelationId());
       }
       if (entity.getNumber() != null){
        model.setNumber(entity.getNumber());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizPointDeductionRulesModel saveModel =  this.repository.save(model);
        return BizPointDeductionRulesConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizPointDeductionRulesModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}