package cn.com.poc.example.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.example.rest.BizExampleRest;
import cn.com.poc.example.service.BizExampleService;
import cn.com.poc.example.dto.BizExampleDto;
import cn.com.poc.example.entity.BizExampleEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.example.convert.BizExampleConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizExampleRestImpl implements BizExampleRest {
   
   	@Resource
    private BizExampleService service;
    			 
	public BizExampleDto getById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
 		return BizExampleConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizExampleDto> getList(BizExampleDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizExampleConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizExampleConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizExampleDto save(BizExampleDto dto) throws Exception{
		Assert.notNull(dto);
		BizExampleEntity entity = BizExampleConvert.dtoToEntity(dto);
       	return BizExampleConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizExampleDto update(BizExampleDto dto) throws Exception{
		Assert.notNull(dto);
		BizExampleEntity entity = BizExampleConvert.dtoToEntity(dto);
       	return BizExampleConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}