package cn.com.poc.example.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.example.service.BizExampleService;
import cn.com.poc.example.model.BizExampleModel;
import cn.com.poc.example.entity.BizExampleEntity;
import cn.com.poc.example.convert.BizExampleConvert;
import cn.com.poc.example.repository.BizExampleRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizExampleServiceImpl extends BaseServiceImpl
 			 implements BizExampleService {
   
   @Resource
   private BizExampleRepository repository;
    			 
   public BizExampleEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizExampleModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizExampleConvert.modelToEntity(model);
   }

       
   public List<BizExampleEntity> findByExample(BizExampleEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizExampleEntity> result = new  ArrayList<BizExampleEntity>();
        BizExampleModel model = new BizExampleModel();
        if (example != null){
            model = BizExampleConvert.entityToModel(example);
        }
        List<BizExampleModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizExampleConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizExampleEntity save(BizExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setBizExampleId(null);
        BizExampleModel model = BizExampleConvert.entityToModel(entity);
        BizExampleModel saveModel =  this.repository.save(model);
        return BizExampleConvert.modelToEntity(saveModel);
    }

    public BizExampleEntity update(BizExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getBizExampleId(),"update pk can not be null");
        BizExampleModel model = this.repository.get(entity.getBizExampleId());

       if (entity.getBizExampleType() != null){
        model.setBizExampleType(entity.getBizExampleType());
       }
       if (entity.getBizExampleBusissesId() != null){
        model.setBizExampleBusissesId(entity.getBizExampleBusissesId());
       }
       if (entity.getBizExampleIcon() != null){
        model.setBizExampleIcon(entity.getBizExampleIcon());
       }
       if (entity.getBizExampleTitle() != null){
        model.setBizExampleTitle(entity.getBizExampleTitle());
       }
       if (entity.getBizExampleFile() != null){
        model.setBizExampleFile(entity.getBizExampleFile());
       }
       if (entity.getBizExampleRemark() != null){
        model.setBizExampleRemark(entity.getBizExampleRemark());
       }
        BizExampleModel saveModel =  this.repository.save(model);
        return BizExampleConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizExampleModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}