package cn.com.poc.expose.aggregate;

import cn.com.poc.data_analyze.domain.DataAnalyzeTimeRange;
import cn.com.poc.data_analyze.query.MemberPointUsageTrendQueryItem;
import cn.com.poc.expose.entity.PlatformAgentUsageDetailEntity;
import cn.com.poc.expose.entity.PlatformAgentUsageEntity;
import cn.com.poc.expose.entity.PlatformPointUsageEntity;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;
import java.util.Map;

/**
 * @author alex.yao
 * @date 2024/12/23
 */
public interface DataStatisticsService {

    /**
     * 平台积分使用情况
     *
     * @param memberId 会员ID
     * @param channels 渠道列表
     */
    PlatformPointUsageEntity platformPointUsage(Long memberId, List<String> channels);

    /**
     * 平台积分使用趋势
     */
    Map<String, List<MemberPointUsageTrendQueryItem>> platformPointTrend(Long memberId, List<String> channels, DataAnalyzeTimeRange timeRange);


    /**
     * 平台应用使用情况
     */
    PlatformAgentUsageEntity platformAgentUsage(Long memberId, List<String> channels);

    /**
     * 平台应用使用明细
     */
    List<PlatformAgentUsageDetailEntity> platformAgentUsageDetail(Long memberId, DataAnalyzeTimeRange timeRange, PagingInfo pagingInfo);


}
