package cn.com.poc.expose.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.data_analyze.query.MemberPointUsageTrendQueryItem;
import cn.com.poc.expose.aggregate.DataStatisticsService;
import cn.com.poc.expose.dto.data_statistics.*;
import cn.com.poc.expose.entity.PlatformAgentUsageDetailEntity;
import cn.com.poc.expose.entity.PlatformAgentUsageEntity;
import cn.com.poc.expose.entity.PlatformPointUsageEntity;
import cn.com.poc.expose.rest.DataStatisticsRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.core.bean.BeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author alex.yao
 * @date 2024/12/23
 */
@Component
public class DataStatisticsRestImpl implements DataStatisticsRest {
    @Resource
    private DataStatisticsService dataStatisticsService;

    @Override
    public PlatformPointUsageDto platformPointUsage(List<String> channels) {
        Assert.notEmpty(channels);
        UserBaseEntity userBaseEntity = BlContext.getCurrentUser();
        PlatformPointUsageEntity platformPointUsageEntity = dataStatisticsService.platformPointUsage(userBaseEntity.userId, channels);

        PlatformPointUsageDto platformPointUsageDto = new PlatformPointUsageDto();
        platformPointUsageDto.setToday(BigDecimal.valueOf(platformPointUsageEntity.getToday()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        platformPointUsageDto.setWeek((BigDecimal.valueOf(platformPointUsageEntity.getWeek()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        platformPointUsageDto.setMonth((BigDecimal.valueOf(platformPointUsageEntity.getMonth()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        platformPointUsageDto.setYear((BigDecimal.valueOf(platformPointUsageEntity.getYear()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        return platformPointUsageDto;
    }

    @Override
    public List<PlatformPointTrendDto> platformPointTrend(PlatformPointTrendRequestDto dto) {
        Assert.notEmpty(dto.getChannel());

        List<PlatformPointTrendDto> result = new ArrayList<>();
        UserBaseEntity userBaseEntity = BlContext.getCurrentUser();
        Map<String, List<MemberPointUsageTrendQueryItem>> pointTrend = dataStatisticsService.platformPointTrend(userBaseEntity.userId, dto.getChannel(), dto.getTimeRange());
        Set<String> keySet = pointTrend.keySet();
        for (String channel : keySet) {
            PlatformPointTrendDto platformPointTrendDto = new PlatformPointTrendDto();
            platformPointTrendDto.setChannel(channel);
            List<MemberPointUsageTrendQueryItem> items = pointTrend.get(channel);
            List<PointUsage> pointUsages = new ArrayList<>();
            for (MemberPointUsageTrendQueryItem item : items) {
                PointUsage pointUsage = new PointUsage();
                pointUsage.setDate(item.getDialogueDate());
                pointUsage.setCount(BigDecimal.valueOf(item.getTotalPoints()).setScale(2, RoundingMode.HALF_UP).doubleValue());
                pointUsages.add(pointUsage);
            }
            platformPointTrendDto.setPointUsages(pointUsages);
            result.add(platformPointTrendDto);
        }
        return result;
    }

    @Override
    public PlatformAgentUsageDto platformAgentUsage(List<String> channels) {
        Assert.notEmpty(channels);
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        PlatformAgentUsageDto platformAgentUsageDto = new PlatformAgentUsageDto();
        PlatformAgentUsageEntity platformAgentUsageEntity = dataStatisticsService.platformAgentUsage(userBaseEntity.getUserId(), channels);
        BeanUtil.copyProperties(platformAgentUsageEntity, platformAgentUsageDto);
        return platformAgentUsageDto;
    }

    @Override
    public List<PlatformAgentUsageDetailDto> platformAgentUsageDetail(PlatformAgentUsageDetailRequestDto dto, PagingInfo pagingInfo) {
        Assert.notNull(dto.getTimeRange());
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        List<PlatformAgentUsageDetailEntity> platformAgentUsageDetailEntities = dataStatisticsService.platformAgentUsageDetail(userBaseEntity.getUserId(), dto.getTimeRange(), pagingInfo);
        List<PlatformAgentUsageDetailDto> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(platformAgentUsageDetailEntities)) {
            result = platformAgentUsageDetailEntities.stream().map(entity -> {
                        PlatformAgentUsageDetailDto platformAgentUsageDetailDto = new PlatformAgentUsageDetailDto();
                        platformAgentUsageDetailDto.setAgentTitle(entity.getAgentTitle());
                        platformAgentUsageDetailDto.setOwner(entity.getOwner());
                        platformAgentUsageDetailDto.setPublishStatus(entity.getPublishStatus());
                        platformAgentUsageDetailDto.setTotalPoint(entity.getTotalPoint());
                        platformAgentUsageDetailDto.setUsageCount(entity.getUsageCount());
                        platformAgentUsageDetailDto.setLastUsageTime(entity.getLastUsageTime());
                        return platformAgentUsageDetailDto;
                    }
            ).collect(Collectors.toList());
        }
        return result;
    }
}
