package cn.com.poc.human_resources.aggregate;

import cn.com.gsst.dify_client.exception.DifyApiException;
import cn.com.poc.human_resources.entity.BizHumanResourcePositionEntity;
import cn.com.poc.human_resources.entity.BizHumanResourceResumeEntity;
import cn.com.poc.human_resources.entity.HumanResourcePositionBaseInfo;
import cn.com.poc.human_resources.entity.position.BaseInfo;
import cn.com.poc.human_resources.entity.position.Job;
import cn.com.poc.human_resources.entity.position.Por;
import cn.com.poc.human_resources.entity.resume.Resume;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.io.IOException;
import java.util.List;

/**
 * 人力资源Agent服务
 *
 * @author alex.yao
 * @date 2025/9/28
 */
public interface HumanResourceService {

    /**
     * 上传简历
     *
     * @param fileURL    文件地址
     * @param positionId 岗位ID
     * @param userId     用户id
     * @return
     */
    Resume uploadResume(String fileURL, Long positionId, Long userId) throws Exception;


    /**
     * 职位配置-对话助手
     *
     * @param demand         需求
     * @param type           对话类型 all- 一键生成  chat-对话
     * @param fileInfos      职位画像字段
     * @param jobInformation 职位信息
     * @param question       问题
     * @param dialoguesId    对话ID
     * @param userId         用户id
     */
    void positionAssistant(String demand,
                           String type,
                           String fileInfos,
                           String jobInformation,
                           String question,
                           String dialoguesId,
                           Long userId)
            throws DifyApiException, IOException, InterruptedException;


    /**
     * 职位配置-保存/更新
     *
     * @param baseInfo 基础信息
     * @param job      职位详情
     * @param por      职位画像
     * @param id       职位id[更新必填]
     * @param memberId 用户id
     */
    BizHumanResourcePositionEntity saveOrUpdatePosition(BaseInfo baseInfo, Job job, Por por, Long id, Long memberId) throws Exception;


    /**
     * 查询职位列表
     *
     * @param userId
     * @param pagingInfo
     */
    List<HumanResourcePositionBaseInfo> listPositions(Long userId, PagingInfo pagingInfo) throws Exception;


    /**
     * 查询职位详情
     *
     * @param positionId 职位id
     */
    BizHumanResourcePositionEntity getPositionDetail(Long userId, Long positionId) throws Exception;

    /**
     * 删除职位[批量]
     *
     * @param userId      用户id
     * @param positionIds 职位ID
     */
    void deletePositions(Long userId, Long... positionIds) throws Exception;

    // ------------------------- 简历 -------------------------- //

    /**
     * 保存简历信息
     *
     * @param userId
     * @param fileURL
     * @param positionId
     * @param resume
     * @throws Exception
     */
    BizHumanResourceResumeEntity saveResume(Long userId, String fileURL, Long positionId, Resume resume) throws Exception;

    /**
     * 更新简历信息
     *
     * @param id
     * @param userId
     * @param fileURL
     * @param positionId
     * @param resume
     * @return
     * @throws Exception
     */
    BizHumanResourceResumeEntity updateResume(Long id, Long userId, String fileURL, Long positionId, Resume resume) throws Exception;

    /**
     * 查询简历列表
     *
     * @param userId
     * @param positionId
     * @param pagingInfo
     */
    List<BizHumanResourceResumeEntity> listResumes(Long userId, Long positionId, PagingInfo pagingInfo) throws Exception;

    /**
     * 查询简历详情
     *
     * @param userId
     * @param resumeId
     * @return
     * @throws Exception
     */
    BizHumanResourceResumeEntity getResumeDetail(Long userId, Long resumeId) throws Exception;

    /**
     * 删除简历[批量]
     *
     * @param resumeIds
     * @throws Exception
     */
    void deleteResumes(Long userId, Long... resumeIds) throws Exception;

}


