package cn.com.poc.human_resources.convert;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.human_resources.dto.BizHumanResourcePositionDto;
import cn.com.poc.human_resources.dto.HumanResourcePositionDto;
import cn.com.poc.human_resources.entity.BizHumanResourcePositionEntity;
import cn.com.poc.human_resources.entity.position.BaseInfo;
import cn.com.poc.human_resources.entity.position.Job;
import cn.com.poc.human_resources.entity.position.Por;
import cn.com.poc.human_resources.model.BizHumanResourcePositionModel;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.baidubce.services.bcc.model.deployset.DeploySetAction.list;


public class BizHumanResourcePositionConvert {

    public static BizHumanResourcePositionEntity modelToEntity(BizHumanResourcePositionModel model) {
        BizHumanResourcePositionEntity entity = new BizHumanResourcePositionEntity();
        entity.setId(model.getId());
        entity.setJobTitle(model.getJobTitle());
        entity.setDepartment(model.getDepartment());
        entity.setWorkLocation(model.getWorkLocation());
        entity.setJobNature(model.getJobNature());
        entity.setNumberOfRecruits(model.getNumberOfRecruits());
        entity.setWorkExperience(model.getWorkExperience());
        entity.setEducationalRe(model.getEducationalRe());
        entity.setSalaryRange(model.getSalaryRange());
        entity.setJobRequirements(model.getJobRequirements());
        entity.setJobDuties(model.getJobDuties());
        entity.setEssential(model.getEssential());
        entity.setBonusPoints(model.getBonusPoints());
        entity.setExclusion(model.getExclusion());
        entity.setMemberId(model.getMemberId());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizHumanResourcePositionModel entityToModel(BizHumanResourcePositionEntity entity) {
        BizHumanResourcePositionModel model = new BizHumanResourcePositionModel();
        model.setId(entity.getId());
        model.setJobTitle(entity.getJobTitle());
        model.setDepartment(entity.getDepartment());
        model.setWorkLocation(entity.getWorkLocation());
        model.setJobNature(entity.getJobNature());
        model.setNumberOfRecruits(entity.getNumberOfRecruits());
        model.setWorkExperience(entity.getWorkExperience());
        model.setEducationalRe(entity.getEducationalRe());
        model.setSalaryRange(entity.getSalaryRange());
        model.setJobRequirements(entity.getJobRequirements());
        model.setJobDuties(entity.getJobDuties());
        model.setEssential(entity.getEssential());
        model.setBonusPoints(entity.getBonusPoints());
        model.setExclusion(entity.getExclusion());
        model.setMemberId(entity.getMemberId());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizHumanResourcePositionDto entityToDto(BizHumanResourcePositionEntity entity) {
        BizHumanResourcePositionDto dto = new BizHumanResourcePositionDto();
        dto.setId(entity.getId());
        dto.setJobTitle(entity.getJobTitle());
        dto.setDepartment(entity.getDepartment());
        dto.setWorkLocation(entity.getWorkLocation());
        dto.setJobNature(entity.getJobNature());
        dto.setNumberOfRecruits(entity.getNumberOfRecruits());
        dto.setWorkExperience(entity.getWorkExperience());
        dto.setEducationalRe(entity.getEducationalRe());
        dto.setSalaryRange(entity.getSalaryRange());
        dto.setJobRequirements(entity.getJobRequirements());
        dto.setJobDuties(entity.getJobDuties());
        dto.setEssential(entity.getEssential());
        dto.setBonusPoints(entity.getBonusPoints());
        dto.setExclusion(entity.getExclusion());
        return dto;
    }

    public static BizHumanResourcePositionEntity dtoToEntity(BizHumanResourcePositionDto dto) {
        BizHumanResourcePositionEntity entity = new BizHumanResourcePositionEntity();
        entity.setId(dto.getId());
        entity.setJobTitle(dto.getJobTitle());
        entity.setDepartment(dto.getDepartment());
        entity.setWorkLocation(dto.getWorkLocation());
        entity.setJobNature(dto.getJobNature());
        entity.setNumberOfRecruits(dto.getNumberOfRecruits());
        entity.setWorkExperience(dto.getWorkExperience());
        entity.setEducationalRe(dto.getEducationalRe());
        entity.setSalaryRange(dto.getSalaryRange());
        entity.setJobRequirements(dto.getJobRequirements());
        entity.setJobDuties(dto.getJobDuties());
        entity.setEssential(dto.getEssential());
        entity.setBonusPoints(dto.getBonusPoints());
        entity.setExclusion(dto.getExclusion());
        return entity;
    }

    public static HumanResourcePositionDto entityToHumanResourcePositionDto(BizHumanResourcePositionEntity positionEntity) {
        HumanResourcePositionDto resourcePositionDto = new HumanResourcePositionDto();

        BaseInfo baseInfo = new BaseInfo();
        baseInfo.setJobTitle(positionEntity.getJobTitle());
        baseInfo.setDepartment(positionEntity.getDepartment());
        baseInfo.setWorkLocation(positionEntity.getWorkLocation());
        baseInfo.setJobNature(positionEntity.getJobNature());
        baseInfo.setNumberOfRecruits(positionEntity.getNumberOfRecruits());
        baseInfo.setWorkExperience(positionEntity.getWorkExperience());
        baseInfo.setEducationalRe(positionEntity.getEducationalRe());
        baseInfo.setSalaryRange(positionEntity.getSalaryRange());
        resourcePositionDto.setBaseInfo(baseInfo);


        Job job = new Job();
        job.setJobDuties(positionEntity.getJobDuties());
        job.setJobRequirements(positionEntity.getJobRequirements());
        resourcePositionDto.setJob(job);

        Por por = new Por();
        if (StringUtils.isNotBlank(positionEntity.getEssential())) {
            JSONObject jsonObject = JSONObject.parseObject(positionEntity.getEssential());
            Map<String, String> map = new HashMap<>();
            for (String key : jsonObject.keySet()) {
                map.put(key, jsonObject.getString(key));
            }
            por.setEssential(map);
        }

        if (StringUtils.isNotBlank(positionEntity.getBonusPoints())) {
            JSONObject jsonObject = JSONObject.parseObject(positionEntity.getBonusPoints());
            Map<String, String> map = new HashMap<>();
            for (String key : jsonObject.keySet()) {
                map.put(key, jsonObject.getString(key));
            }
            por.setBonusPoints(map);
        }

        if (StringUtils.isNotBlank(positionEntity.getExclusion())) {
            JSONObject jsonObject = JSONObject.parseObject(positionEntity.getExclusion());
            Map<String, String> map = new HashMap<>();
            for (String key : jsonObject.keySet()) {
                map.put(key, jsonObject.getString(key));
            }
            por.setExclusion(map);
        }
        resourcePositionDto.setPor(por);
        return resourcePositionDto;
    }
}