package cn.com.poc.human_resources.convert;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.human_resources.dto.BizHumanResourceResumeDto;
import cn.com.poc.human_resources.dto.ResumeDto;
import cn.com.poc.human_resources.entity.BizHumanResourceResumeEntity;
import cn.com.poc.human_resources.entity.resume.Info;
import cn.com.poc.human_resources.entity.resume.Resume;
import cn.com.poc.human_resources.entity.resume.Tag;
import cn.com.poc.human_resources.model.BizHumanResourceResumeModel;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;


public class BizHumanResourceResumeConvert {

    public static BizHumanResourceResumeEntity modelToEntity(BizHumanResourceResumeModel model) {
        BizHumanResourceResumeEntity entity = new BizHumanResourceResumeEntity();
        entity.setId(model.getId());
        entity.setName(model.getName());
        entity.setCurrentPosition(model.getCurrentPosition());
        entity.setPosition(model.getPosition());
        entity.setFileUrl(model.getFileUrl());
        entity.setCoreSkills(model.getCoreSkills());
        entity.setEducationBackground(model.getEducationBackground());
        entity.setEducationExperience(model.getEducationExperience());
        entity.setGenderAndAge(model.getGenderAndAge());
        entity.setOccupationalHistory(model.getOccupationalHistory());
        entity.setOther(model.getOther());
        entity.setWorkExperience(model.getWorkExperience());
        entity.setWorkLocation(model.getWorkLocation());
        entity.setLabel(model.getLabel());
        entity.setEvaluate(model.getEvaluate());
        entity.setMatchedDegree(model.getMatchedDegree());
        entity.setMemberId(model.getMemberId());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizHumanResourceResumeModel entityToModel(BizHumanResourceResumeEntity entity) {
        BizHumanResourceResumeModel model = new BizHumanResourceResumeModel();
        model.setId(entity.getId());
        model.setName(entity.getName());
        model.setCurrentPosition(entity.getCurrentPosition());
        model.setPosition(entity.getPosition());
        model.setFileUrl(entity.getFileUrl());
        model.setCoreSkills(entity.getCoreSkills());
        model.setEducationBackground(entity.getEducationBackground());
        model.setEducationExperience(entity.getEducationExperience());
        model.setGenderAndAge(entity.getGenderAndAge());
        model.setOccupationalHistory(entity.getOccupationalHistory());
        model.setOther(entity.getOther());
        model.setWorkExperience(entity.getWorkExperience());
        model.setWorkLocation(entity.getWorkLocation());
        model.setLabel(entity.getLabel());
        model.setEvaluate(entity.getEvaluate());
        model.setMatchedDegree(entity.getMatchedDegree());
        model.setMemberId(entity.getMemberId());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizHumanResourceResumeDto entityToDto(BizHumanResourceResumeEntity entity) {
        BizHumanResourceResumeDto dto = new BizHumanResourceResumeDto();
        dto.setId(entity.getId());
        dto.setName(entity.getName());
        dto.setCurrentPosition(entity.getCurrentPosition());
        dto.setPosition(entity.getPosition());
        dto.setFileUrl(entity.getFileUrl());
        dto.setCoreSkills(entity.getCoreSkills());
        dto.setEducationBackground(entity.getEducationBackground());
        dto.setEducationExperience(entity.getEducationExperience());
        dto.setGenderAndAge(entity.getGenderAndAge());
        dto.setOccupationalHistory(entity.getOccupationalHistory());
        dto.setOther(entity.getOther());
        dto.setWorkExperience(entity.getWorkExperience());
        dto.setWorkLocation(entity.getWorkLocation());
        dto.setLabel(entity.getLabel());
        dto.setEvaluate(entity.getEvaluate());
        dto.setMatchedDegree(entity.getMatchedDegree());
        dto.setMemberId(entity.getMemberId());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizHumanResourceResumeEntity dtoToEntity(BizHumanResourceResumeDto dto) {
        BizHumanResourceResumeEntity entity = new BizHumanResourceResumeEntity();
        entity.setId(dto.getId());
        entity.setName(dto.getName());
        entity.setCurrentPosition(dto.getCurrentPosition());
        entity.setPosition(dto.getPosition());
        entity.setFileUrl(dto.getFileUrl());
        entity.setCoreSkills(dto.getCoreSkills());
        entity.setEducationBackground(dto.getEducationBackground());
        entity.setEducationExperience(dto.getEducationExperience());
        entity.setGenderAndAge(dto.getGenderAndAge());
        entity.setOccupationalHistory(dto.getOccupationalHistory());
        entity.setOther(dto.getOther());
        entity.setWorkExperience(dto.getWorkExperience());
        entity.setWorkLocation(dto.getWorkLocation());
        entity.setLabel(dto.getLabel());
        entity.setEvaluate(dto.getEvaluate());
        entity.setMatchedDegree(dto.getMatchedDegree());
        entity.setMemberId(dto.getMemberId());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }

    public static ResumeDto entityToResumeDto(BizHumanResourceResumeEntity entity) {
        ResumeDto dto = new ResumeDto();
        dto.setId(entity.getId());
        dto.setPositionId(entity.getPosition());
        dto.setFileUrl(entity.getFileUrl());

        Info info = new Info();
        info.setName(entity.getName());
        info.setCoreSkills(JsonUtils.deSerialize(entity.getCoreSkills(), new TypeReference<List<String>>() {
        }.getType()));
        info.setEducationBackground(JsonUtils.deSerialize(entity.getEducationBackground(), String.class));

        if (StringUtils.isNotBlank(entity.getEducationExperience())) {
            JSONObject jsonObject = JSONObject.parseObject(entity.getEducationExperience());
            LinkedHashMap<String, String> map = new LinkedHashMap<>();
            for (String key : jsonObject.keySet()) {
                String value = jsonObject.getString(key);
                map.put(key, value);
            }
            info.setEducationExperience(map);
        }
        info.setGenderAndAge(JsonUtils.deSerialize(entity.getGenderAndAge(), String.class));

        if (StringUtils.isNotBlank(entity.getOccupationalHistory())) {
            JSONObject jsonObject = JSONObject.parseObject(entity.getOccupationalHistory());
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<>();
            for (String key : jsonObject.keySet()) {
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                ArrayList<String> list = new ArrayList<>(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); i++) {
                    list.add(jsonArray.getString(i));
                }
                map.put(key, list);
            }
            info.setOccupationalHistory(map);
        }
        info.setCurrentPosition(entity.getCurrentPosition());
        info.setOther(JsonUtils.deSerialize(entity.getOther(), new TypeReference<List<String>>() {
        }.getType()));
        info.setWorkExperience(JsonUtils.deSerialize(entity.getWorkExperience(), String.class));
        info.setWorkLocation(JsonUtils.deSerialize(entity.getWorkLocation(), String.class));
        dto.setInfo(info);

        Tag tag = new Tag();
        tag.setEvaluate(JsonUtils.deSerialize(entity.getEvaluate(), String.class));
        tag.setLabel(JsonUtils.deSerialize(entity.getLabel(), new TypeReference<List<String>>() {
        }.getType()));
        tag.setMatchedDegree(entity.getMatchedDegree());

        dto.setTag(tag);
        return dto;

    }

    public static BizHumanResourceResumeEntity resumeToEntity(Resume resume) {
        BizHumanResourceResumeEntity bizHumanResourceResumeEntity = new BizHumanResourceResumeEntity();
        //info
        bizHumanResourceResumeEntity.setName(resume.getInfo().getName());
        bizHumanResourceResumeEntity.setCurrentPosition(resume.getInfo().getCurrentPosition());
        bizHumanResourceResumeEntity.setCoreSkills(JsonUtils.serialize(resume.getInfo().getCoreSkills()));
        bizHumanResourceResumeEntity.setEducationBackground(JsonUtils.serialize(resume.getInfo().getEducationBackground()));
        bizHumanResourceResumeEntity.setEducationExperience(JsonUtils.serialize(resume.getInfo().getEducationExperience()));
        bizHumanResourceResumeEntity.setGenderAndAge(JsonUtils.serialize(resume.getInfo().getGenderAndAge()));
        bizHumanResourceResumeEntity.setOccupationalHistory(JsonUtils.serialize(resume.getInfo().getOccupationalHistory()));
        bizHumanResourceResumeEntity.setOther(JsonUtils.serialize(resume.getInfo().getOther()));
        bizHumanResourceResumeEntity.setWorkExperience(JsonUtils.serialize(resume.getInfo().getWorkExperience()));
        bizHumanResourceResumeEntity.setWorkLocation(JsonUtils.serialize(resume.getInfo().getWorkLocation()));
        // tag
        bizHumanResourceResumeEntity.setLabel(JsonUtils.serialize(resume.getTag().getLabel()));
        bizHumanResourceResumeEntity.setEvaluate(JsonUtils.serialize(resume.getTag().getEvaluate()));
        bizHumanResourceResumeEntity.setMatchedDegree(Long.valueOf(resume.getTag().getMatchedDegree()));
        return bizHumanResourceResumeEntity;
    }
}