package cn.com.poc.human_resources.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_human_resource_resume
 * 人力资源-简历信息
 */
@Entity
@Table(name = "biz_human_resource_resume")
@DynamicInsert
@DynamicUpdate
public class BizHumanResourceResumeModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 主键id
     */
    private java.lang.Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Long getId() {
        return this.id;
    }

    public void setId(java.lang.Long id) {
        this.id = id;
        super.addValidField("id");
    }

    /**
     * name
     * 姓名
     */
    private String name;

    @Column(name = "name", length = 100)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
        super.addValidField("name");
    }

    /**
     * position
     * 职位ID
     */
    private java.lang.Long position;

    @Column(name = "position", length = 19)
    public java.lang.Long getPosition() {
        return this.position;
    }

    public void setPosition(java.lang.Long position) {
        this.position = position;
        super.addValidField("position");
    }

    /**
     * 当前职位
     */
    private String currentPosition;

    @Column(name = "current_position", length = 100)
    public String getCurrentPosition() {
        return currentPosition;
    }

    public void setCurrentPosition(String currentPosition) {
        this.currentPosition = currentPosition;
        super.addValidField("currentPosition");
    }

    /**
     * 简历文件地址
     */
    private String fileUrl;

    @Column(name = "file_url", length = 200)
    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }

    /**
     * core_skills
     * 核心技能
     */
    private java.lang.String coreSkills;

    @Column(name = "core_skills", length = 1073741824)
    public java.lang.String getCoreSkills() {
        return this.coreSkills;
    }

    public void setCoreSkills(java.lang.String coreSkills) {
        this.coreSkills = coreSkills;
        super.addValidField("coreSkills");
    }


    /**
     * education_background
     * 教育背景
     */
    private java.lang.String educationBackground;

    @Column(name = "education_background", length = 100)
    public java.lang.String getEducationBackground() {
        return this.educationBackground;
    }

    public void setEducationBackground(java.lang.String educationBackground) {
        this.educationBackground = educationBackground;
        super.addValidField("educationBackground");
    }


    /**
     * education_experience
     * 教育经历
     */
    private java.lang.String educationExperience;

    @Column(name = "education_experience", length = 1073741824)
    public java.lang.String getEducationExperience() {
        return this.educationExperience;
    }

    public void setEducationExperience(java.lang.String educationExperience) {
        this.educationExperience = educationExperience;
        super.addValidField("educationExperience");
    }


    /**
     * gender_and_age
     * 性别-年龄
     */
    private java.lang.String genderAndAge;

    @Column(name = "gender_and_age", length = 100)
    public java.lang.String getGenderAndAge() {
        return this.genderAndAge;
    }

    public void setGenderAndAge(java.lang.String genderAndAge) {
        this.genderAndAge = genderAndAge;
        super.addValidField("genderAndAge");
    }


    /**
     * occupational_history
     * 工作经历
     */
    private java.lang.String occupationalHistory;

    @Column(name = "occupational_history", length = 1073741824)
    public java.lang.String getOccupationalHistory() {
        return this.occupationalHistory;
    }

    public void setOccupationalHistory(java.lang.String occupationalHistory) {
        this.occupationalHistory = occupationalHistory;
        super.addValidField("occupationalHistory");
    }


    /**
     * other
     * 技能证书、项目经验等补充内容
     */
    private java.lang.String other;

    @Column(name = "other", length = 1073741824)
    public java.lang.String getOther() {
        return this.other;
    }

    public void setOther(java.lang.String other) {
        this.other = other;
        super.addValidField("other");
    }


    /**
     * work_experience
     * 工作经验
     */
    private java.lang.String workExperience;

    @Column(name = "work_experience", length = 100)
    public java.lang.String getWorkExperience() {
        return this.workExperience;
    }

    public void setWorkExperience(java.lang.String workExperience) {
        this.workExperience = workExperience;
        super.addValidField("workExperience");
    }


    /**
     * work_location
     * 工作地址
     */
    private java.lang.String workLocation;

    @Column(name = "work_location", length = 100)
    public java.lang.String getWorkLocation() {
        return this.workLocation;
    }

    public void setWorkLocation(java.lang.String workLocation) {
        this.workLocation = workLocation;
        super.addValidField("workLocation");
    }


    /**
     * label
     * 标签
     */
    private java.lang.String label;

    @Column(name = "label", length = 1073741824)
    public java.lang.String getLabel() {
        return this.label;
    }

    public void setLabel(java.lang.String label) {
        this.label = label;
        super.addValidField("label");
    }


    /**
     * evaluate
     * AI综合评价
     */
    private java.lang.String evaluate;

    @Column(name = "evaluate", length = 2147483647)
    public java.lang.String getEvaluate() {
        return this.evaluate;
    }

    public void setEvaluate(java.lang.String evaluate) {
        this.evaluate = evaluate;
        super.addValidField("evaluate");
    }


    /**
     * matched_degree
     * 匹配分
     */
    private java.lang.Long matchedDegree;

    @Column(name = "matched_degree", length = 22)
    public java.lang.Long getMatchedDegree() {
        return this.matchedDegree;
    }

    public void setMatchedDegree(java.lang.Long matchedDegree) {
        this.matchedDegree = matchedDegree;
        super.addValidField("matchedDegree");
    }


    /**
     * member_id
     * 上传人ID
     */
    private java.lang.Long memberId;

    @Column(name = "member_id", length = 19)
    public java.lang.Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.Long memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * is_deleted
     * 是否删除 1、Y 是 2、N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 225)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 225)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}