package cn.com.poc.human_resources.rest;

import cn.com.poc.human_resources.dto.*;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 人力资源Agent服务接口
 *
 * @author alex.yao
 * @date 2025/9/28
 */
@Permission(Access.Safety)
public interface HumanResourceRest extends BaseRest {

    /**
     * 上传简历
     */
    Object uploadResume(@RequestBody UploadResumeDto uploadResumeDto) throws Exception;

    /**
     * 职位助手-对话/内容生成
     *
     * @param positionAssistantDto
     * @throws Exception
     */
    void positionAssistant(@RequestBody PositionAssistantDto positionAssistantDto) throws Exception;

    // ------------------------- 职位 -------------------------- //

    /**
     * 保存职位信息
     *
     * @param humanResourcePositionDto
     * @throws Exception
     */
    void savePosition(@RequestBody HumanResourcePositionDto humanResourcePositionDto) throws Exception;


    /**
     * 查询职位列表
     */
    List<HumanResourcePositionBaseInfoDto> listPositions(PagingInfo pagingInfo) throws Exception;


    /**
     * 查询职位详情
     *
     * @param positionId 职位id
     */
    HumanResourcePositionDto getPositionDetail(@RequestParam Long positionId) throws Exception;

    /**
     * 删除职位[批量]
     *
     * @param positionIds 职位ID
     */
    void deletePositions(@RequestParam Long... positionIds) throws Exception;

    // ------------------------- 简历 -------------------------- //

    /**
     * 保存简历信息
     *
     * @param saveResumeDto
     * @throws Exception
     */
    void saveResume(@RequestBody SaveResumeDto saveResumeDto) throws Exception;

    /**
     * 查询简历列表
     *
     * @param positionId 岗位ID
     */
    List<ResumeDto> listResumes(@RequestParam Long positionId, PagingInfo pagingInfo) throws Exception;

    /**
     * 查询简历详情
     *
     * @param resumeId
     * @return
     * @throws Exception
     */
    ResumeDto getResumeDetail(@RequestParam Long resumeId) throws Exception;

    /**
     * 删除简历[批量]
     *
     * @param resumeIds
     * @throws Exception
     */
    void deleteResumes(@RequestParam Long... resumeIds) throws Exception;
}