package cn.com.poc.human_resources.service.impl;

import cn.com.poc.human_resources.query.PositionListQueryCondition;
import cn.com.poc.human_resources.query.PositionListQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.human_resources.service.BizHumanResourcePositionService;
import cn.com.poc.human_resources.model.BizHumanResourcePositionModel;
import cn.com.poc.human_resources.entity.BizHumanResourcePositionEntity;
import cn.com.poc.human_resources.convert.BizHumanResourcePositionConvert;
import cn.com.poc.human_resources.repository.BizHumanResourcePositionRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizHumanResourcePositionServiceImpl extends BaseServiceImpl
        implements BizHumanResourcePositionService {

    @Resource
    private BizHumanResourcePositionRepository repository;

    public BizHumanResourcePositionEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizHumanResourcePositionModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizHumanResourcePositionConvert.modelToEntity(model);
    }


    public List<BizHumanResourcePositionEntity> findByExample(BizHumanResourcePositionEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizHumanResourcePositionEntity> result = new ArrayList<BizHumanResourcePositionEntity>();
        BizHumanResourcePositionModel model = new BizHumanResourcePositionModel();
        if (example != null) {
            model = BizHumanResourcePositionConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizHumanResourcePositionModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizHumanResourcePositionConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizHumanResourcePositionEntity save(BizHumanResourcePositionEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizHumanResourcePositionModel model = BizHumanResourcePositionConvert.entityToModel(entity);
        BizHumanResourcePositionModel saveModel = this.repository.save(model);
        return BizHumanResourcePositionConvert.modelToEntity(saveModel);
    }

    public BizHumanResourcePositionEntity update(BizHumanResourcePositionEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizHumanResourcePositionModel model = this.repository.get(entity.getId());

        if (entity.getJobTitle() != null) {
            model.setJobTitle(entity.getJobTitle());
        }
        if (entity.getDepartment() != null) {
            model.setDepartment(entity.getDepartment());
        }
        if (entity.getWorkLocation() != null) {
            model.setWorkLocation(entity.getWorkLocation());
        }
        if (entity.getJobNature() != null) {
            model.setJobNature(entity.getJobNature());
        }
        if (entity.getNumberOfRecruits() != null) {
            model.setNumberOfRecruits(entity.getNumberOfRecruits());
        }
        if (entity.getWorkExperience() != null) {
            model.setWorkExperience(entity.getWorkExperience());
        }
        if (entity.getEducationalRe() != null) {
            model.setEducationalRe(entity.getEducationalRe());
        }
        if (entity.getSalaryRange() != null) {
            model.setSalaryRange(entity.getSalaryRange());
        }
        if (entity.getJobRequirements() != null) {
            model.setJobRequirements(entity.getJobRequirements());
        }
        if (entity.getJobDuties() != null) {
            model.setJobDuties(entity.getJobDuties());
        }
        if (entity.getEssential() != null) {
            model.setEssential(entity.getEssential());
        }
        if (entity.getBonusPoints() != null) {
            model.setBonusPoints(entity.getBonusPoints());
        }
        if (entity.getExclusion() != null) {
            model.setExclusion(entity.getExclusion());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizHumanResourcePositionModel saveModel = this.repository.save(model);
        return BizHumanResourcePositionConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizHumanResourcePositionModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<PositionListQueryItem> positionListQuery(PositionListQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, PositionListQueryItem.class, pagingInfo);
    }
}