package cn.com.poc.human_resources.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.human_resources.service.BizHumanResourceResumeService;
import cn.com.poc.human_resources.model.BizHumanResourceResumeModel;
import cn.com.poc.human_resources.entity.BizHumanResourceResumeEntity;
import cn.com.poc.human_resources.convert.BizHumanResourceResumeConvert;
import cn.com.poc.human_resources.repository.BizHumanResourceResumeRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizHumanResourceResumeServiceImpl extends BaseServiceImpl
        implements BizHumanResourceResumeService {

    @Resource
    private BizHumanResourceResumeRepository repository;

    public BizHumanResourceResumeEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizHumanResourceResumeModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizHumanResourceResumeConvert.modelToEntity(model);
    }


    public List<BizHumanResourceResumeEntity> findByExample(BizHumanResourceResumeEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizHumanResourceResumeEntity> result = new ArrayList<BizHumanResourceResumeEntity>();
        BizHumanResourceResumeModel model = new BizHumanResourceResumeModel();
        if (example != null) {
            model = BizHumanResourceResumeConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizHumanResourceResumeModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizHumanResourceResumeConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizHumanResourceResumeEntity save(BizHumanResourceResumeEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizHumanResourceResumeModel model = BizHumanResourceResumeConvert.entityToModel(entity);
        BizHumanResourceResumeModel saveModel = this.repository.save(model);
        return BizHumanResourceResumeConvert.modelToEntity(saveModel);
    }

    public BizHumanResourceResumeEntity update(BizHumanResourceResumeEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizHumanResourceResumeModel model = this.repository.get(entity.getId());

        if (entity.getPosition() != null) {
            model.setPosition(entity.getPosition());
        }
        if (entity.getFileUrl() != null) {
            model.setFileUrl(entity.getFileUrl());
        }
        if (entity.getCoreSkills() != null) {
            model.setCoreSkills(entity.getCoreSkills());
        }
        if (entity.getEducationBackground() != null) {
            model.setEducationBackground(entity.getEducationBackground());
        }
        if (entity.getEducationExperience() != null) {
            model.setEducationExperience(entity.getEducationExperience());
        }
        if (entity.getGenderAndAge() != null) {
            model.setGenderAndAge(entity.getGenderAndAge());
        }
        if (entity.getOccupationalHistory() != null) {
            model.setOccupationalHistory(entity.getOccupationalHistory());
        }
        if (entity.getOther() != null) {
            model.setOther(entity.getOther());
        }
        if (entity.getWorkExperience() != null) {
            model.setWorkExperience(entity.getWorkExperience());
        }
        if (entity.getWorkLocation() != null) {
            model.setWorkLocation(entity.getWorkLocation());
        }
        if (entity.getLabel() != null) {
            model.setLabel(entity.getLabel());
        }
        if (entity.getEvaluate() != null) {
            model.setEvaluate(entity.getEvaluate());
        }
        if (entity.getMatchedDegree() != null) {
            model.setMatchedDegree(entity.getMatchedDegree());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizHumanResourceResumeModel saveModel = this.repository.save(model);
        return BizHumanResourceResumeConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizHumanResourceResumeModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}