package cn.com.poc.knowledge.aggregate.impl;

import cn.com.poc.knowledge.aggregate.QAKnowledgeService;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.service.BizKnowledgeDocumentService;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandQAKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.ChunkInfo;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeStructResult;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
@Service
public class QAKnowledgeServiceImpl implements QAKnowledgeService {

    final private Logger logger = LoggerFactory.getLogger(QAKnowledgeService.class);

    @Resource
    private DemandQAKnowledgeService demandQAKnowledgeService;

    @Resource
    private BizKnowledgeDocumentService bizKnowledgeDocumentService;

    @Override
    public QAKnowledgeChunkResult getChunkInfo(Integer kdId, String query, PagingInfo pagingInfo) {
        logger.info("getChunkInfo: kdId={}, query={}, pagingInfo={}", kdId, query, pagingInfo);
        String knowledgeId = getKnowledgeId(kdId);
        return demandQAKnowledgeService.getKnowledgeChunkInfos(knowledgeId, query, pagingInfo);
    }

    @Override
    public void openKnowledgeChunk(Integer kdId, String chunkRelationId, String isOpen) {
        logger.info("openKnowledgeChunk: kdId={}, chunkRelationId={}, isOpen={}", kdId, chunkRelationId, isOpen);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.openKnowledgeChunk(knowledgeId, chunkRelationId, isOpen);
    }

    @Override
    public void deleteKnowledgeChunk(Integer kdId, String chunkRelationId) {
        logger.info("deleteKnowledgeChunk: kdId={}, chunkRelationId={}", kdId, chunkRelationId);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.deleteKnowledgeChunk(knowledgeId, chunkRelationId);
    }

    @Override
    public void batchDeleteKnowledgeChunk(Integer kdId, List<String> chunkRelationIds) {
        logger.info("batchDeleteKnowledgeChunk: kdId={}, chunkRelationIds={}", kdId, chunkRelationIds);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.batchDeleteKnowledgeChunk(knowledgeId, chunkRelationIds);
    }

    @Override
    public void updateKnowledgeChunkDoc(Integer kdId, String chunkRelationId, Long structId, String content) {
        logger.info("updateKnowledgeChunkDoc: kdId={}, chunkRelationId={}, structId={}, content={}", kdId, chunkRelationId, structId, content);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.updateKnowledgeChunkDoc(knowledgeId, chunkRelationId, structId, content);
    }

    @Override
    public void updateKnowledgeChunkDoc(Integer kdId, String chunkRelationId, List<ChunkInfo> chunkInfos) {
        logger.info("updateKnowledgeChunkDoc: kdId={}, chunkRelationId={}, chunkInfos={}", kdId, chunkRelationId, chunkInfos);
        String knowledgeId = getKnowledgeId(kdId);
        checkChunkInfos(chunkInfos);
        demandQAKnowledgeService.updateKnowledgeChunkDoc(knowledgeId, chunkRelationId, chunkInfos);
    }

    @Override
    public void addKnowledgeChunk(Integer kdId, List<ChunkInfo> chunkInfos, Integer chunkSort) {
        logger.info("addKnowledgeChunk: kdId={}, chunkInfos={}, chunkSort={}", kdId, chunkInfos, chunkSort);
        String knowledgeId = getKnowledgeId(kdId);
        checkChunkInfos(chunkInfos);
        demandQAKnowledgeService.addKnowledgeChunk(knowledgeId, chunkInfos, chunkSort);
    }

    @Override
    public void updateKnowledgeStruct(Integer kdId, Long structId, String structName, String isIndex) {
        logger.info("updateKnowledgeStruct: kdId={}, structId={}, structName={}, isIndex={}", kdId, structId, structName, isIndex);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.updateKnowledgeStruct(knowledgeId, structId, structName, isIndex);
    }

    @Override
    public QAKnowledgeStructResult getKnowledgeStruct(Integer kdId) {
        logger.info("getKnowledgeStruct: kdId={}", kdId);
        String knowledgeId = getKnowledgeId(kdId);
        return demandQAKnowledgeService.getKnowledgeStruct(knowledgeId);
    }

    @Override
    public void updateKnowledgeChunkSort(Integer kdId, String chunkRelationId, Integer chunkSort) {
        logger.info("updateKnowledgeChunkSort: kdId={}, chunkRelationId={}, chunkSort={}", kdId, chunkRelationId, chunkSort);
        String knowledgeId = getKnowledgeId(kdId);
        demandQAKnowledgeService.updateKnowledgeChunkSort(knowledgeId, chunkRelationId, chunkSort);
    }

    private String getKnowledgeId(Integer kdId) {
        BizKnowledgeDocumentEntity knowledgeDocumentEntity = bizKnowledgeDocumentService.get(kdId);
        if (knowledgeDocumentEntity == null) {
            logger.error("Can not find knowledge document, kdId={}", kdId);
            throw new BusinessException("Can not find knowledge document");
        }
        return knowledgeDocumentEntity.getKnowledgeId();
    }

    private void checkChunkInfos(List<ChunkInfo> chunkInfos) {
        int totalWordCount = 0;
        for (ChunkInfo chunkInfo : chunkInfos) {
            totalWordCount += chunkInfo.getContent().length();
            if (chunkInfo.getContent().length() > 850) {
                throw new I18nMessageException("exception/file.cell.content.more.than.850");
            }
            if (totalWordCount > 3000) {
                throw new I18nMessageException("exception/file.rows.content.more.than.3000");
            }
        }
    }


}
