package cn.com.poc.knowledge.cache;

import cn.com.poc.common.domain.database.TableInfo;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.DatabaseUtil;
import cn.com.poc.common.utils.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/4/29
 */
public class DatabaseTableInfoCache {

    private static Logger logger = LoggerFactory.getLogger(DatabaseTableInfoCache.class);

    private static final String prefix = "KNOWLEDGE_DATABASE_TABLE_INFO:";

    private static Long expireTime = 5 * 60L;

    public static boolean updateOrSaveCache(int id, List<TableInfo> tableInfos) {
        logger.info("updateOrSaveCache id:{},tableInfos:{}", id, tableInfos);
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        return redisService.set(prefix + id, tableInfos, expireTime);
    }

    public static List<TableInfo> getCache(int id) {
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        if (redisService.hasKey(prefix + id)) {
            return (List<TableInfo>) redisService.get(prefix + id);
        }
        return null;
    }

}
