package cn.com.poc.knowledge.cache;

import cn.com.poc.common.utils.SpringUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;

/**
 * @author alex.yao
 * @date 2025/9/1
 */
public class KnowledgeDefaultCache {

    private FmxParamConfigService fmxParamConfigService;

    public KnowledgeDefaultCache() {
        fmxParamConfigService = SpringUtils.getBean(FmxParamConfigService.class);
    }

    public Integer[] getDefaultKnowledgeId() {
        String param = fmxParamConfigService.getParam("knowledge.default.id");
        if (StringUtils.isNotBlank(param)) {
            String[] knowledgeId = param.split(";");
            if (ArrayUtils.isNotEmpty(knowledgeId)) {
                Integer[] res = new Integer[knowledgeId.length];
                for (int i = 0; i < knowledgeId.length; i++) {
                    res[i] = Integer.valueOf(knowledgeId[i]);
                }
                return res;
            }
        }
        return ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY;
    }

}
