package cn.com.poc.knowledge.rest;

import cn.com.poc.knowledge.dto.QAKnowledgeChunkDto;
import cn.com.poc.knowledge.dto.QAKnowledgeStructDto;
import cn.com.poc.knowledge.dto.UpsertChunkInfoDto;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
@Permission(Access.Safety)
public interface QAKnowledgeRest extends BaseRest {

    /**
     * 开关知识库分片
     */
    void openKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 删除知识库分片
     */
    void deleteKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 更新知识库分片内容
     */
    void updateKnowledgeChunkDoc(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 批量更新知识库分片内容
     *
     * @param dto
     */
    void batchUpdateKnowledgeChunkDoc(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 新增知识库分片
     */
    void addKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 获取问答知识库分片信息
     */
    QAKnowledgeChunkDto getQAKnowledgeChunks(@RequestParam Integer kdId, @RequestParam(required = false) String query, PagingInfo pagingInfo);

    /**
     * 更新知识库结构信息
     */
    void updateKnowledgeChunk(@RequestParam Integer kdId, @RequestParam Long structId, @RequestParam(required = false) String structName, @RequestParam(required = false) String isIndex);

    /**
     * 批量删除知识库分片
     */
    void batchDeleteKnowledgeChunks(@RequestParam Integer kdId, @RequestParam List<String> chunkRelationIds);

    /**
     * 更新分片顺序
     */
    void updateChunkSort(@RequestParam Integer kdId, @RequestParam String chunkRelationId, @RequestParam Integer sort);

    /**
     * 获取问答知识库索引结构
     *
     * @param kdId
     * @return
     */
    QAKnowledgeStructDto getKnowledgeStruct(@RequestParam Integer kdId);

}
