package cn.com.poc.law.aggregate.impl;

import cn.com.poc.law.aggregate.AiLawyerWritingTemplateService;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateConvert;
import cn.com.poc.law.dto.AiLawyerWritingTemplateResult;
import cn.com.poc.law.dto.BizAiLawyerWritingTemplateDto;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateEntity;
import cn.com.poc.law.query.LawyerWritingTemplateTypeQueryCondition;
import cn.com.poc.law.query.LawyerWritingTemplateTypeQueryItem;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateService;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateTypeService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @author alex.yao
 * @date 2025/6/20
 */
@Service
public class AiLawyerWritingTemplateServiceImpl implements AiLawyerWritingTemplateService {

    private final Logger logger = LoggerFactory.getLogger(AiLawyerWritingTemplateServiceImpl.class);

    @Resource
    private BizAiLawyerWritingTemplateService bizAiLawyerWritingTemplateService;
    @Resource
    private BizAiLawyerWritingTemplateTypeService bizAiLawyerWritingTemplateTypeService;

    @Override
    public AiLawyerWritingTemplateResult getTemplateWritingList() throws Exception {

        AiLawyerWritingTemplateResult aiLawyerWritingTemplateResult = new AiLawyerWritingTemplateResult();

        List<BizAiLawyerWritingTemplateEntity> templateWritingList = bizAiLawyerWritingTemplateService.getTemplateWritingList();
        if (CollectionUtils.isEmpty(templateWritingList)) {
            return null;
        }
        List<BizAiLawyerWritingTemplateDto> bizAiLawyerWritingTemplateDtoList = templateWritingList.stream().map(item -> BizAiLawyerWritingTemplateConvert.entityToDto(item)).collect(Collectors.toList());

        List<String> typeList = bizAiLawyerWritingTemplateDtoList.stream().map(item -> item.getLawyerWritingTemplateType()).distinct().collect(Collectors.toList());

        LawyerWritingTemplateTypeQueryCondition condition = new LawyerWritingTemplateTypeQueryCondition();
        condition.setLawyerWritingTemplateTypeList(typeList);
        List<LawyerWritingTemplateTypeQueryItem> lawyerWritingTemplateTypeQueryItems = bizAiLawyerWritingTemplateTypeService.queryLawyerWritingTemplateType(condition, null);

        Map<String, List<LawyerWritingTemplateTypeQueryItem>> typeMap = lawyerWritingTemplateTypeQueryItems.stream().collect(Collectors.groupingBy(item -> item.getLawyerWritingTemplateType()));


        if (CollectionUtils.isNotEmpty(lawyerWritingTemplateTypeQueryItems)) {
            for (BizAiLawyerWritingTemplateDto bizAiLawyerWritingTemplateDto : bizAiLawyerWritingTemplateDtoList) {
                if (CollectionUtils.isNotEmpty(typeMap.get(bizAiLawyerWritingTemplateDto.getLawyerWritingTemplateType()))) {
                    bizAiLawyerWritingTemplateDto.setLawyerWritingTemplateType(typeMap.get(bizAiLawyerWritingTemplateDto.getLawyerWritingTemplateType()).get(0).getLawyerWritingTemplateName());
                }
            }
        }

        Map<String, List<BizAiLawyerWritingTemplateDto>> bizAiLawyerWritingTemplateEntityMap = bizAiLawyerWritingTemplateDtoList.stream().collect(Collectors.groupingBy(item -> item.getLawyerWritingTemplateType()));
        aiLawyerWritingTemplateResult.setBizAiLawyerWritingTemplateEntityMap(bizAiLawyerWritingTemplateEntityMap);
        return aiLawyerWritingTemplateResult;
    }
}
