package cn.com.poc.law.jsonSerializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author：Roger Wu
 * @name：JacksonDateFormatDeSerializer
 * @Date：2025-08-14 16:07
 */
public class JacksonDateFormatDeSerializer extends  JsonDeserializer<String> {

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");


    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String date = p.getText();
        try {
            // 解析为 Date 对象
            return String.valueOf(dateFormat.parse(date).getTime());
        } catch (ParseException e) {
            // 抛出运行时异常，如果解析失败
            return null;
        }
    }
}
