package cn.com.poc.law.jsonSerializer;

import cn.com.poc.common.utils.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.text.SimpleDateFormat;

/**
 * @Author：Roger Wu
 * @name：JacksonDateFormatlSerializer
 * @Date：2025-08-13 18:58
 */
@Configuration
public class JacksonDateFormatSerializer extends JsonSerializer<String> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (StringUtils.isBlank(value)) {
            value = null;
        }
        jsonGenerator.writeString(value);

        if (value != null) {
            jsonGenerator.writeString(dateFormat.format(value));
        } else {
            jsonGenerator.writeNull();
        }
    }

}
