package cn.com.poc.law.rest;

import cn.com.poc.law.dto.AiLawDialoguesDto;
import cn.com.poc.law.dto.LegislativeDocumentDto;
import cn.com.poc.law.entity.legislativeDocument.LegislativeDocumentResult;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;

@Permission(Access.Safety)
public interface BizAiLegislativeDocumentWritingRest extends BaseRest {

    /**
     * 立案调查保存
     *
     * @param dto
     * @return
     */
    LegislativeDocumentResult legislativeApply(@RequestBody AiLawDialoguesDto dto) throws Exception;

    /**
     * 获取立案调查详情
     *
     * @param dialoguesId
     * @return
     * @throws Exception
     */
    LegislativeDocumentResult getLegislativeApplyDetail(String dialoguesId) throws Exception;

    /**
     * 保存立案调查
     * @param legislativeDocumentDto
     * @throws Exception
     */
    void saveLegislativeApply(@RequestBody LegislativeDocumentDto legislativeDocumentDto) throws Exception;
}